/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BatchJobObservation implements ObservationDocumentation
{
    BATCH_JOB_OBSERVATION{

        @Override
        public String getName() {
            return "spring.batch.job";
        }

        @Override
        public String getContextualName() {
            return "%s";
        }

        @Override
        public KeyName[] getLowCardinalityKeyNames() {
            return JobLowCardinalityTags.values();
        }

        @Override
        public KeyName[] getHighCardinalityKeyNames() {
            return JobHighCardinalityTags.values();
        }

        @Override
        public String getPrefix() {
            return "spring.batch";
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum JobHighCardinalityTags implements KeyName
    {
        JOB_INSTANCE_ID{

            @Override
            public String asString() {
                return "spring.batch.job.instanceId";
            }
        }
        ,
        JOB_EXECUTION_ID{

            @Override
            public String asString() {
                return "spring.batch.job.executionId";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum JobLowCardinalityTags implements KeyName
    {
        JOB_NAME{

            @Override
            public String asString() {
                return "spring.batch.job.name";
            }
        }
        ,
        JOB_STATUS{

            @Override
            public String asString() {
                return "spring.batch.job.status";
            }
        };

    }
}

