/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BatchStepObservation implements ObservationDocumentation
{
    BATCH_STEP_OBSERVATION{

        @Override
        public String getName() {
            return "spring.batch.step";
        }

        @Override
        public String getContextualName() {
            return "%s";
        }

        @Override
        public KeyName[] getLowCardinalityKeyNames() {
            return StepLowCardinalityTags.values();
        }

        @Override
        public KeyName[] getHighCardinalityKeyNames() {
            return StepHighCardinalityTags.values();
        }

        @Override
        public String getPrefix() {
            return "spring.batch";
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum StepHighCardinalityTags implements KeyName
    {
        STEP_EXECUTION_ID{

            @Override
            public String asString() {
                return "spring.batch.step.executionId";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum StepLowCardinalityTags implements KeyName
    {
        STEP_NAME{

            @Override
            public String asString() {
                return "spring.batch.step.name";
            }
        }
        ,
        STEP_TYPE{

            @Override
            public String asString() {
                return "spring.batch.step.type";
            }
        }
        ,
        JOB_NAME{

            @Override
            public String asString() {
                return "spring.batch.step.job.name";
            }
        }
        ,
        STEP_STATUS{

            @Override
            public String asString() {
                return "spring.batch.step.status";
            }
        };

    }
}

