/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.KeyValues;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.observability.BatchJobContext;
import org.springframework.batch.core.observability.BatchJobObservation;
import org.springframework.batch.core.observability.BatchJobObservationConvention;

public class DefaultBatchJobObservationConvention
implements BatchJobObservationConvention {
    @Override
    public KeyValues getLowCardinalityKeyValues(BatchJobContext context) {
        JobExecution execution = context.getJobExecution();
        return KeyValues.of(BatchJobObservation.JobLowCardinalityTags.JOB_NAME.withValue(execution.getJobInstance().getJobName()), BatchJobObservation.JobLowCardinalityTags.JOB_STATUS.withValue(execution.getExitStatus().getExitCode()));
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(BatchJobContext context) {
        JobExecution execution = context.getJobExecution();
        return KeyValues.of(BatchJobObservation.JobHighCardinalityTags.JOB_INSTANCE_ID.withValue(String.valueOf(execution.getJobInstance().getInstanceId())), BatchJobObservation.JobHighCardinalityTags.JOB_EXECUTION_ID.withValue(String.valueOf(execution.getId())));
    }
}

