/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.resource;

import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.policy.SimpleCompletionPolicy;
import org.springframework.util.Assert;

public class StepExecutionSimpleCompletionPolicy
implements StepExecutionListener,
CompletionPolicy {
    private CompletionPolicy delegate;
    private String keyName = "commit.interval";

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    @Override
    public void beforeStep(StepExecution stepExecution) {
        JobParameters jobParameters = stepExecution.getJobParameters();
        Assert.state(jobParameters.getParameters().containsKey(this.keyName), "JobParameters do not contain Long parameter with key=[" + this.keyName + "]");
        this.delegate = new SimpleCompletionPolicy(jobParameters.getLong(this.keyName).intValue());
    }

    @Override
    public boolean isComplete(RepeatContext context, RepeatStatus result) {
        Assert.state(this.delegate != null, "The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.isComplete(context, result);
    }

    @Override
    public boolean isComplete(RepeatContext context) {
        Assert.state(this.delegate != null, "The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.isComplete(context);
    }

    @Override
    public RepeatContext start(RepeatContext parent) {
        Assert.state(this.delegate != null, "The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        return this.delegate.start(parent);
    }

    @Override
    public void update(RepeatContext context) {
        Assert.state(this.delegate != null, "The delegate resource has not been initialised. Remember to register this object as a StepListener.");
        this.delegate.update(context);
    }

    public String toString() {
        return this.delegate == null ? this.keyName : this.delegate.toString();
    }
}

