/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.scope.context.JobSynchronizationManager;

@Aspect
public class JobScopeManager {
    @Around(value="execution(void org.springframework.batch.core.Job+.execute(*)) && target(job) && args(jobExecution)")
    public void execute(Job job, JobExecution jobExecution) {
        JobSynchronizationManager.register(jobExecution);
        try {
            job.execute(jobExecution);
        }
        finally {
            JobSynchronizationManager.release();
        }
    }
}

