/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.data.MongoCursorItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoCursorItemReaderBuilder<T> {
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private MongoOperations template;
    private Class<? extends T> targetType;
    private String collection;
    private Query query;
    private String jsonQuery;
    private List<Object> parameterValues = new ArrayList<Object>();
    private String fields;
    private Map<String, Sort.Direction> sorts;
    private String hint;
    private int batchSize;
    private int limit;
    private Duration maxTime;

    public MongoCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> query(Query query2) {
        this.query = query2;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> jsonQuery(String query2) {
        this.jsonQuery = query2;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> parameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> fields(String fields) {
        this.fields = fields;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MongoCursorItemReaderBuilder<T> maxTime(Duration maxTime) {
        Assert.notNull((Object)maxTime, "maxTime must not be null.");
        this.maxTime = maxTime;
        return this;
    }

    public MongoCursorItemReader<T> build() {
        Assert.notNull((Object)this.template, "template is required.");
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        Assert.notNull(this.targetType, "targetType is required.");
        Assert.state(StringUtils.hasText(this.jsonQuery) || this.query != null, "A query is required");
        if (StringUtils.hasText(this.jsonQuery) || this.query != null) {
            Assert.notNull(this.sorts, "sorts map is required.");
        }
        MongoCursorItemReader<? extends T> reader = new MongoCursorItemReader<T>();
        reader.setSaveState(this.saveState);
        reader.setName(this.name);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setTemplate(this.template);
        reader.setTargetType(this.targetType);
        reader.setCollection(this.collection);
        reader.setQuery(this.query);
        reader.setQuery(this.jsonQuery);
        reader.setParameterValues(this.parameterValues);
        reader.setFields(this.fields);
        reader.setSort(this.sorts);
        reader.setHint(this.hint);
        reader.setBatchSize(this.batchSize);
        reader.setLimit(this.limit);
        if (this.maxTime != null) {
            reader.setMaxTime(this.maxTime);
        }
        return reader;
    }
}

