/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import org.springframework.batch.item.data.MongoItemWriter;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.util.Assert;

public class MongoItemWriterBuilder<T> {
    private MongoOperations template;
    private String collection;
    private MongoItemWriter.Mode mode = MongoItemWriter.Mode.UPSERT;

    @Deprecated(since="5.1", forRemoval=true)
    public MongoItemWriterBuilder<T> delete(boolean delete) {
        this.mode = delete ? MongoItemWriter.Mode.REMOVE : MongoItemWriter.Mode.UPSERT;
        return this;
    }

    public MongoItemWriterBuilder<T> mode(MongoItemWriter.Mode mode) {
        this.mode = mode;
        return this;
    }

    public MongoItemWriterBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoItemWriterBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoItemWriter<T> build() {
        Assert.notNull((Object)this.template, "template is required.");
        MongoItemWriter writer = new MongoItemWriter();
        writer.setTemplate(this.template);
        writer.setMode(this.mode);
        writer.setCollection(this.collection);
        return writer;
    }
}

