/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.DataSource;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.batch.item.database.Order;
import org.springframework.batch.item.database.PagingQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JdbcPagingItemReader<T>
extends AbstractPagingItemReader<T>
implements InitializingBean {
    private static final String START_AFTER_VALUE = "start.after";
    public static final int VALUE_NOT_SET = -1;
    private DataSource dataSource;
    private PagingQueryProvider queryProvider;
    private Map<String, Object> parameterValues;
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private RowMapper<T> rowMapper;
    private String firstPageSql;
    private String remainingPagesSql;
    private Map<String, Object> startAfterValues;
    private Map<String, Object> previousStartAfterValues;
    private int fetchSize = -1;

    public JdbcPagingItemReader() {
        this.setName(ClassUtils.getShortName(JdbcPagingItemReader.class));
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryProvider(PagingQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state(this.dataSource != null, "DataSource may not be null");
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        if (this.fetchSize != -1) {
            jdbcTemplate.setFetchSize(this.fetchSize);
        }
        jdbcTemplate.setMaxRows(this.getPageSize());
        this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(jdbcTemplate);
        Assert.state(this.queryProvider != null, "QueryProvider may not be null");
        this.queryProvider.init(this.dataSource);
        this.firstPageSql = this.queryProvider.generateFirstPageQuery(this.getPageSize());
        this.remainingPagesSql = this.queryProvider.generateRemainingPagesQuery(this.getPageSize());
    }

    @Override
    protected void doReadPage() {
        List query2;
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        PagingRowMapper rowCallback = new PagingRowMapper();
        if (this.getPage() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL used for reading first page: [" + this.firstPageSql + "]");
            }
            query2 = this.parameterValues != null && this.parameterValues.size() > 0 ? (this.queryProvider.isUsingNamedParameters() ? this.namedParameterJdbcTemplate.query(this.firstPageSql, this.getParameterMap(this.parameterValues, null), rowCallback) : this.getJdbcTemplate().query(this.firstPageSql, rowCallback, this.getParameterList(this.parameterValues, null).toArray())) : this.getJdbcTemplate().query(this.firstPageSql, rowCallback);
        } else if (this.startAfterValues != null) {
            this.previousStartAfterValues = this.startAfterValues;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL used for reading remaining pages: [" + this.remainingPagesSql + "]");
            }
            query2 = this.queryProvider.isUsingNamedParameters() ? this.namedParameterJdbcTemplate.query(this.remainingPagesSql, this.getParameterMap(this.parameterValues, this.startAfterValues), rowCallback) : this.getJdbcTemplate().query(this.remainingPagesSql, rowCallback, this.getParameterList(this.parameterValues, this.startAfterValues).toArray());
        } else {
            query2 = Collections.emptyList();
        }
        this.results.addAll(query2);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (this.isSaveState()) {
            if (this.isAtEndOfPage() && this.startAfterValues != null) {
                executionContext.put(this.getExecutionContextKey(START_AFTER_VALUE), this.startAfterValues);
            } else if (this.previousStartAfterValues != null) {
                executionContext.put(this.getExecutionContextKey(START_AFTER_VALUE), this.previousStartAfterValues);
            }
        }
    }

    private boolean isAtEndOfPage() {
        return this.getCurrentItemCount() % this.getPageSize() == 0;
    }

    @Override
    public void open(ExecutionContext executionContext) {
        if (this.isSaveState()) {
            this.startAfterValues = (Map)executionContext.get(this.getExecutionContextKey(START_AFTER_VALUE));
            if (this.startAfterValues == null) {
                this.startAfterValues = new LinkedHashMap<String, Object>();
            }
        }
        super.open(executionContext);
    }

    private Map<String, Object> getParameterMap(Map<String, Object> values, Map<String, Object> sortKeyValues) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        if (values != null) {
            parameterMap.putAll(values);
        }
        if (sortKeyValues != null && !sortKeyValues.isEmpty()) {
            for (Map.Entry<String, Object> sortKey : sortKeyValues.entrySet()) {
                parameterMap.put("_" + sortKey.getKey(), sortKey.getValue());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using parameterMap:" + parameterMap);
        }
        return parameterMap;
    }

    private List<Object> getParameterList(Map<String, Object> values, Map<String, Object> sortKeyValue) {
        TreeMap<String, Object> sm = new TreeMap<String, Object>();
        if (values != null) {
            sm.putAll(values);
        }
        ArrayList<Object> parameterList = new ArrayList<Object>();
        parameterList.addAll(sm.values());
        if (sortKeyValue != null && sortKeyValue.size() > 0) {
            ArrayList<Map.Entry<String, Object>> keys = new ArrayList<Map.Entry<String, Object>>(sortKeyValue.entrySet());
            for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    parameterList.add(((Map.Entry)keys.get(j)).getValue());
                }
                parameterList.add(((Map.Entry)keys.get(i)).getValue());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using parameterList:" + parameterList);
        }
        return parameterList;
    }

    private JdbcTemplate getJdbcTemplate() {
        return (JdbcTemplate)this.namedParameterJdbcTemplate.getJdbcOperations();
    }

    private class PagingRowMapper
    implements RowMapper<T> {
        private PagingRowMapper() {
        }

        @Override
        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            JdbcPagingItemReader.this.startAfterValues = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Order> sortKey : JdbcPagingItemReader.this.queryProvider.getSortKeys().entrySet()) {
                JdbcPagingItemReader.this.startAfterValues.put(sortKey.getKey(), rs.getObject(sortKey.getKey()));
            }
            return JdbcPagingItemReader.this.rowMapper.mapRow(rs, rowNum);
        }
    }
}

