/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.util.StringUtils;

public class SqlitePagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, false, this.buildLimitClause(pageSize));
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        if (StringUtils.hasText(this.getGroupClause())) {
            return SqlPagingQueryUtils.generateLimitGroupedSqlQuery(this, this.buildLimitClause(pageSize));
        }
        return SqlPagingQueryUtils.generateLimitSqlQuery(this, true, this.buildLimitClause(pageSize));
    }

    private String buildLimitClause(int pageSize) {
        return "LIMIT " + pageSize;
    }
}

