/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.ldif.builder;

import org.springframework.batch.item.ldif.MappingLdifReader;
import org.springframework.batch.item.ldif.RecordCallbackHandler;
import org.springframework.batch.item.ldif.RecordMapper;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class MappingLdifReaderBuilder<T> {
    private Resource resource;
    private int recordsToSkip = 0;
    private boolean strict = true;
    private RecordCallbackHandler skippedRecordsCallback;
    private RecordMapper<T> recordMapper;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public MappingLdifReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MappingLdifReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MappingLdifReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MappingLdifReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MappingLdifReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public MappingLdifReaderBuilder<T> skippedRecordsCallback(RecordCallbackHandler skippedRecordsCallback) {
        this.skippedRecordsCallback = skippedRecordsCallback;
        return this;
    }

    public MappingLdifReaderBuilder<T> recordsToSkip(int recordsToSkip) {
        this.recordsToSkip = recordsToSkip;
        return this;
    }

    public MappingLdifReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public MappingLdifReaderBuilder<T> recordMapper(RecordMapper<T> recordMapper) {
        this.recordMapper = recordMapper;
        return this;
    }

    public MappingLdifReader<T> build() {
        Assert.notNull((Object)this.resource, "Resource is required.");
        Assert.notNull(this.recordMapper, "RecordMapper is required.");
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        MappingLdifReader<T> reader = new MappingLdifReader<T>();
        reader.setResource(this.resource);
        reader.setRecordsToSkip(this.recordsToSkip);
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setRecordMapper(this.recordMapper);
        reader.setName(this.name);
        if (this.skippedRecordsCallback != null) {
            reader.setSkippedRecordsCallback(this.skippedRecordsCallback);
        }
        reader.setStrict(this.strict);
        return reader;
    }
}

