/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.redis;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.util.Assert;

public class RedisItemReader<K, V>
implements ItemStreamReader<V> {
    private final RedisTemplate<K, V> redisTemplate;
    private final ScanOptions scanOptions;
    private Cursor<K> cursor;

    public RedisItemReader(RedisTemplate<K, V> redisTemplate, ScanOptions scanOptions) {
        Assert.notNull(redisTemplate, "redisTemplate must not be null");
        Assert.notNull((Object)scanOptions, "scanOptions must no be null");
        this.redisTemplate = redisTemplate;
        this.scanOptions = scanOptions;
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.cursor = this.redisTemplate.scan(this.scanOptions);
    }

    @Override
    public V read() throws Exception {
        if (this.cursor.hasNext()) {
            Object nextKey = this.cursor.next();
            return (V)this.redisTemplate.opsForValue().get(nextKey);
        }
        return null;
    }

    @Override
    public void close() throws ItemStreamException {
        this.cursor.close();
    }
}

