/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SynchronizedItemStreamWriter<T>
implements ItemStreamWriter<T>,
InitializingBean {
    private ItemStreamWriter<T> delegate;
    private final Lock lock = new ReentrantLock();

    public void setDelegate(ItemStreamWriter<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        this.lock.lock();
        try {
            this.delegate.write(items);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.delegate.update(executionContext);
    }

    @Override
    public void close() throws ItemStreamException {
        this.delegate.close();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.delegate != null, "A delegate item writer is required");
    }
}

