/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support.builder;

import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.support.CompositeItemProcessor;
import org.springframework.util.Assert;

public class CompositeItemProcessorBuilder<I, O> {
    private List<? extends ItemProcessor<?, ?>> delegates;

    public CompositeItemProcessorBuilder<I, O> delegates(List<? extends ItemProcessor<?, ?>> delegates) {
        this.delegates = delegates;
        return this;
    }

    public CompositeItemProcessorBuilder<I, O> delegates(ItemProcessor<?, ?> ... delegates) {
        return this.delegates(Arrays.asList(delegates));
    }

    public CompositeItemProcessor<I, O> build() {
        Assert.notNull(this.delegates, "A list of delegates is required.");
        Assert.notEmpty(this.delegates, "The delegates list must have one or more delegates.");
        CompositeItemProcessor processor = new CompositeItemProcessor();
        processor.setDelegates(this.delegates);
        return processor;
    }
}

