/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.validator;

import jakarta.validation.Validator;
import org.springframework.batch.item.validator.SpringValidator;
import org.springframework.batch.item.validator.ValidatingItemProcessor;
import org.springframework.util.Assert;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class BeanValidatingItemProcessor<T>
extends ValidatingItemProcessor<T> {
    private final Validator validator;

    public BeanValidatingItemProcessor() {
        try (LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();){
            localValidatorFactoryBean.afterPropertiesSet();
            this.validator = localValidatorFactoryBean.getValidator();
        }
    }

    public BeanValidatingItemProcessor(LocalValidatorFactoryBean localValidatorFactoryBean) {
        Assert.notNull((Object)localValidatorFactoryBean, "localValidatorFactoryBean must not be null");
        this.validator = localValidatorFactoryBean.getValidator();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SpringValidatorAdapter springValidatorAdapter = new SpringValidatorAdapter(this.validator);
        SpringValidator springValidator = new SpringValidator();
        springValidator.setValidator(springValidatorAdapter);
        springValidator.afterPropertiesSet();
        this.setValidator(springValidator);
        super.afterPropertiesSet();
    }
}

