/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Date;
import java.util.Map;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.spring.batch.SpringBatchEndpoint;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBatchProducer.class);
    private final JobLauncher jobLauncher;
    private final Job job;
    private final JobRegistry jobRegistry;

    public SpringBatchProducer(SpringBatchEndpoint endpoint, JobLauncher jobLauncher, Job job, JobRegistry jobRegistry) {
        super(endpoint);
        this.job = job;
        this.jobLauncher = jobLauncher;
        this.jobRegistry = jobRegistry;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        JobParameters jobParameters = this.prepareJobParameters(exchange.getIn().getHeaders());
        String messageJobName = jobParameters.getString("CamelSpringBatchJobName");
        Job job2run = this.job;
        if (messageJobName != null) {
            job2run = this.jobRegistry != null ? this.jobRegistry.getJob(messageJobName) : CamelContextHelper.mandatoryLookup(this.getEndpoint().getCamelContext(), messageJobName, Job.class);
        }
        if (job2run == null) {
            exchange.setException(new CamelExchangeException("jobName was not specified in the endpoint construction  and header CamelSpringBatchJobName could not be found", exchange));
            return;
        }
        JobExecution jobExecution = this.jobLauncher.run(job2run, jobParameters);
        exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
        exchange.getOut().setBody(jobExecution);
    }

    protected JobParameters prepareJobParameters(Map<String, Object> headers) {
        JobParametersBuilder parametersBuilder = new JobParametersBuilder();
        for (Map.Entry<String, Object> headerEntry : headers.entrySet()) {
            String headerKey = headerEntry.getKey();
            Object headerValue = headerEntry.getValue();
            if (headerValue instanceof Date) {
                parametersBuilder.addDate(headerKey, (Date)headerValue);
                continue;
            }
            if (headerValue instanceof Long) {
                parametersBuilder.addLong(headerKey, (Long)headerValue);
                continue;
            }
            if (headerValue instanceof Double) {
                parametersBuilder.addDouble(headerKey, (Double)headerValue);
                continue;
            }
            if (headerValue != null) {
                parametersBuilder.addString(headerKey, headerValue.toString());
                continue;
            }
            parametersBuilder.addString(headerKey, null);
        }
        JobParameters jobParameters = parametersBuilder.toJobParameters();
        LOG.debug("Prepared parameters for Spring Batch job: {}", (Object)jobParameters);
        return jobParameters;
    }
}

