/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Entity;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.Nullable;

public class JobExecution
extends Entity {
    private final JobParameters jobParameters;
    private JobInstance jobInstance;
    private volatile Collection<StepExecution> stepExecutions = Collections.synchronizedSet(new LinkedHashSet());
    private volatile BatchStatus status = BatchStatus.STARTING;
    private volatile LocalDateTime startTime = null;
    private volatile LocalDateTime createTime = LocalDateTime.now();
    private volatile LocalDateTime endTime = null;
    private volatile LocalDateTime lastUpdated = null;
    private volatile ExitStatus exitStatus = ExitStatus.UNKNOWN;
    private volatile ExecutionContext executionContext = new ExecutionContext();
    private volatile transient List<Throwable> failureExceptions = new CopyOnWriteArrayList<Throwable>();

    public JobExecution(JobExecution original) {
        this.jobParameters = original.getJobParameters();
        this.jobInstance = original.getJobInstance();
        this.stepExecutions = original.getStepExecutions();
        this.status = original.getStatus();
        this.startTime = original.getStartTime();
        this.createTime = original.getCreateTime();
        this.endTime = original.getEndTime();
        this.lastUpdated = original.getLastUpdated();
        this.exitStatus = original.getExitStatus();
        this.executionContext = original.getExecutionContext();
        this.failureExceptions = original.getFailureExceptions();
        this.setId(original.getId());
        this.setVersion(original.getVersion());
    }

    public JobExecution(JobInstance job, Long id, @Nullable JobParameters jobParameters) {
        super(id);
        this.jobInstance = job;
        this.jobParameters = jobParameters == null ? new JobParameters() : jobParameters;
    }

    public JobExecution(JobInstance job, JobParameters jobParameters) {
        this(job, null, jobParameters);
    }

    public JobExecution(Long id, JobParameters jobParameters) {
        this(null, id, jobParameters);
    }

    public JobExecution(Long id) {
        this(null, id, null);
    }

    public JobParameters getJobParameters() {
        return this.jobParameters;
    }

    @Nullable
    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public void setJobInstance(JobInstance jobInstance) {
        this.jobInstance = jobInstance;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    @Nullable
    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public BatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(BatchStatus status) {
        this.status = status;
    }

    public void upgradeStatus(BatchStatus status) {
        this.status = this.status.upgradeTo(status);
    }

    public Long getJobId() {
        if (this.jobInstance != null) {
            return this.jobInstance.getId();
        }
        return null;
    }

    public void setExitStatus(ExitStatus exitStatus) {
        this.exitStatus = exitStatus;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public Collection<StepExecution> getStepExecutions() {
        return List.copyOf(this.stepExecutions);
    }

    public StepExecution createStepExecution(String stepName) {
        StepExecution stepExecution = new StepExecution(stepName, this);
        this.stepExecutions.add(stepExecution);
        return stepExecution;
    }

    public boolean isRunning() {
        return this.status.isRunning();
    }

    public boolean isStopping() {
        return this.status == BatchStatus.STOPPING;
    }

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    void addStepExecution(StepExecution stepExecution) {
        this.stepExecutions.add(stepExecution);
    }

    @Nullable
    public LocalDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(LocalDateTime lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public List<Throwable> getFailureExceptions() {
        return this.failureExceptions;
    }

    public synchronized void addFailureException(Throwable t) {
        this.failureExceptions.add(t);
    }

    public synchronized List<Throwable> getAllFailureExceptions() {
        HashSet<Throwable> allExceptions = new HashSet<Throwable>(this.failureExceptions);
        for (StepExecution stepExecution : this.stepExecutions) {
            allExceptions.addAll(stepExecution.getFailureExceptions());
        }
        return new ArrayList<Throwable>(allExceptions);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.failureExceptions = new ArrayList<Throwable>();
    }

    @Override
    public String toString() {
        return super.toString() + String.format(", startTime=%s, endTime=%s, lastUpdated=%s, status=%s, exitStatus=%s, job=[%s], jobParameters=[%s]", new Object[]{this.startTime, this.endTime, this.lastUpdated, this.status, this.exitStatus, this.jobInstance, this.jobParameters});
    }

    public void addStepExecutions(List<StepExecution> stepExecutions) {
        if (stepExecutions != null) {
            this.stepExecutions.removeAll(stepExecutions);
            this.stepExecutions.addAll(stepExecutions);
        }
    }
}

