/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job;

import java.util.List;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CompositeJobParametersValidator
implements JobParametersValidator,
InitializingBean {
    private List<JobParametersValidator> validators;

    @Override
    public void validate(@Nullable JobParameters parameters) throws JobParametersInvalidException {
        for (JobParametersValidator validator : this.validators) {
            validator.validate(parameters);
        }
    }

    public void setValidators(List<JobParametersValidator> validators) {
        this.validators = validators;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.validators != null, "The 'validators' may not be null");
        Assert.state(!this.validators.isEmpty(), "The 'validators' may not be empty");
    }
}

