/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.launch.support;

import java.util.Properties;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.launch.support.SimpleJobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;

public class JobOperatorFactoryBean
implements FactoryBean<JobOperator>,
InitializingBean {
    private static final String TRANSACTION_ISOLATION_LEVEL_PREFIX = "ISOLATION_";
    private static final String TRANSACTION_PROPAGATION_PREFIX = "PROPAGATION_";
    private PlatformTransactionManager transactionManager;
    private TransactionAttributeSource transactionAttributeSource;
    private JobRegistry jobRegistry;
    private JobLauncher jobLauncher;
    private JobRepository jobRepository;
    private JobExplorer jobExplorer;
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();
    private final ProxyFactory proxyFactory = new ProxyFactory();

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.transactionManager, "TransactionManager must not be null");
        Assert.notNull((Object)this.jobLauncher, "JobLauncher must not be null");
        Assert.notNull((Object)this.jobRegistry, "JobRegistry must not be null");
        Assert.notNull((Object)this.jobExplorer, "JobExplorer must not be null");
        Assert.notNull((Object)this.jobRepository, "JobRepository must not be null");
        if (this.transactionAttributeSource == null) {
            Properties transactionAttributes = new Properties();
            String transactionProperties = String.join((CharSequence)",", TRANSACTION_PROPAGATION_PREFIX + Propagation.REQUIRED, TRANSACTION_ISOLATION_LEVEL_PREFIX + Isolation.DEFAULT);
            transactionAttributes.setProperty("stop*", transactionProperties);
            this.transactionAttributeSource = new NameMatchTransactionAttributeSource();
            ((NameMatchTransactionAttributeSource)this.transactionAttributeSource).setProperties(transactionAttributes);
        }
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobExplorer(JobExplorer jobExplorer) {
        this.jobExplorer = jobExplorer;
    }

    public void setJobParametersConverter(JobParametersConverter jobParametersConverter) {
        this.jobParametersConverter = jobParametersConverter;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionAttributeSource(TransactionAttributeSource transactionAttributeSource) {
        Assert.notNull((Object)transactionAttributeSource, "transactionAttributeSource must not be null.");
        this.transactionAttributeSource = transactionAttributeSource;
    }

    @Override
    public Class<?> getObjectType() {
        return JobOperator.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public JobOperator getObject() throws Exception {
        TransactionInterceptor advice = new TransactionInterceptor((TransactionManager)this.transactionManager, this.transactionAttributeSource);
        this.proxyFactory.addAdvice(advice);
        this.proxyFactory.setProxyTargetClass(false);
        this.proxyFactory.addInterface(JobOperator.class);
        this.proxyFactory.setTarget(this.getTarget());
        return (JobOperator)this.proxyFactory.getProxy(this.getClass().getClassLoader());
    }

    private SimpleJobOperator getTarget() throws Exception {
        SimpleJobOperator simpleJobOperator = new SimpleJobOperator();
        simpleJobOperator.setJobRegistry(this.jobRegistry);
        simpleJobOperator.setJobExplorer(this.jobExplorer);
        simpleJobOperator.setJobRepository(this.jobRepository);
        simpleJobOperator.setJobLauncher(this.jobLauncher);
        simpleJobOperator.setJobParametersConverter(this.jobParametersConverter);
        simpleJobOperator.afterPropertiesSet();
        return simpleJobOperator;
    }
}

