/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractJdbcBatchMetadataDao
implements InitializingBean {
    public static final String DEFAULT_TABLE_PREFIX = "BATCH_";
    public static final int DEFAULT_EXIT_MESSAGE_LENGTH = 2500;
    public static final int DEFAULT_SHORT_CONTEXT_LENGTH = 2500;
    private String tablePrefix = "BATCH_";
    private int clobTypeToUse = 2005;
    private JdbcOperations jdbcTemplate;

    protected String getQuery(String base) {
        return StringUtils.replace(base, "%PREFIX%", this.tablePrefix);
    }

    protected String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setJdbcTemplate(JdbcOperations jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    protected JdbcOperations getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public int getClobTypeToUse() {
        return this.clobTypeToUse;
    }

    public void setClobTypeToUse(int clobTypeToUse) {
        this.clobTypeToUse = clobTypeToUse;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.jdbcTemplate != null, "JdbcOperations is required");
    }
}

