/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.converter.DateToStringConverter;
import org.springframework.batch.core.converter.LocalDateTimeToStringConverter;
import org.springframework.batch.core.converter.LocalDateToStringConverter;
import org.springframework.batch.core.converter.LocalTimeToStringConverter;
import org.springframework.batch.core.converter.StringToDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateTimeConverter;
import org.springframework.batch.core.converter.StringToLocalTimeConverter;
import org.springframework.batch.core.repository.dao.AbstractJdbcBatchMetadataDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdbcJobExecutionDao
extends AbstractJdbcBatchMetadataDao
implements JobExecutionDao,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JdbcJobExecutionDao.class);
    private static final String SAVE_JOB_EXECUTION = "INSERT INTO %PREFIX%JOB_EXECUTION(JOB_EXECUTION_ID, JOB_INSTANCE_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, VERSION, CREATE_TIME, LAST_UPDATED)\n\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)\n";
    private static final String CHECK_JOB_EXECUTION_EXISTS = "SELECT COUNT(*)\nFROM %PREFIX%JOB_EXECUTION\nWHERE JOB_EXECUTION_ID = ?\n";
    private static final String GET_STATUS = "SELECT STATUS\nFROM %PREFIX%JOB_EXECUTION\nWHERE JOB_EXECUTION_ID = ?\n";
    private static final String UPDATE_JOB_EXECUTION = "UPDATE %PREFIX%JOB_EXECUTION\nSET START_TIME = ?, END_TIME = ?,  STATUS = ?, EXIT_CODE = ?, EXIT_MESSAGE = ?, VERSION = ?, CREATE_TIME = ?, LAST_UPDATED = ?\nWHERE JOB_EXECUTION_ID = ? AND VERSION = ?\n";
    private static final String FIND_JOB_EXECUTIONS = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION\nFROM %PREFIX%JOB_EXECUTION\nWHERE JOB_INSTANCE_ID = ?\nORDER BY JOB_EXECUTION_ID DESC\n";
    private static final String GET_LAST_EXECUTION = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION\nFROM %PREFIX%JOB_EXECUTION E\nWHERE JOB_INSTANCE_ID = ? AND JOB_EXECUTION_ID IN (SELECT MAX(JOB_EXECUTION_ID) FROM %PREFIX%JOB_EXECUTION E2 WHERE E2.JOB_INSTANCE_ID = ?)\n";
    private static final String GET_EXECUTION_BY_ID = "SELECT JOB_EXECUTION_ID, START_TIME, END_TIME, STATUS, EXIT_CODE, EXIT_MESSAGE, CREATE_TIME, LAST_UPDATED, VERSION\nFROM %PREFIX%JOB_EXECUTION\nWHERE JOB_EXECUTION_ID = ?\n";
    private static final String GET_RUNNING_EXECUTIONS = "SELECT E.JOB_EXECUTION_ID, E.START_TIME, E.END_TIME, E.STATUS, E.EXIT_CODE, E.EXIT_MESSAGE, E.CREATE_TIME, E.LAST_UPDATED, E.VERSION, E.JOB_INSTANCE_ID\nFROM %PREFIX%JOB_EXECUTION E, %PREFIX%JOB_INSTANCE I\nWHERE E.JOB_INSTANCE_ID=I.JOB_INSTANCE_ID AND I.JOB_NAME=? AND E.STATUS IN ('STARTING', 'STARTED', 'STOPPING')\n";
    private static final String CURRENT_VERSION_JOB_EXECUTION = "SELECT VERSION\nFROM %PREFIX%JOB_EXECUTION\nWHERE JOB_EXECUTION_ID=?\n";
    private static final String FIND_PARAMS_FROM_ID = "SELECT JOB_EXECUTION_ID, PARAMETER_NAME, PARAMETER_TYPE, PARAMETER_VALUE, IDENTIFYING\nFROM %PREFIX%JOB_EXECUTION_PARAMS\nWHERE JOB_EXECUTION_ID = ?\n";
    private static final String CREATE_JOB_PARAMETERS = "INSERT INTO %PREFIX%JOB_EXECUTION_PARAMS(JOB_EXECUTION_ID, PARAMETER_NAME, PARAMETER_TYPE, PARAMETER_VALUE, IDENTIFYING)\n\tVALUES (?, ?, ?, ?, ?)\n";
    private static final String DELETE_JOB_EXECUTION = "DELETE FROM %PREFIX%JOB_EXECUTION\nWHERE JOB_EXECUTION_ID = ?\n";
    private static final String DELETE_JOB_EXECUTION_PARAMETERS = "DELETE FROM %PREFIX%JOB_EXECUTION_PARAMS\nWHERE JOB_EXECUTION_ID = ?\n";
    private int exitMessageLength = 2500;
    private DataFieldMaxValueIncrementer jobExecutionIncrementer;
    private ConfigurableConversionService conversionService;
    private final Lock lock = new ReentrantLock();

    public JdbcJobExecutionDao() {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter(new DateToStringConverter());
        conversionService.addConverter(new StringToDateConverter());
        conversionService.addConverter(new LocalDateToStringConverter());
        conversionService.addConverter(new StringToLocalDateConverter());
        conversionService.addConverter(new LocalTimeToStringConverter());
        conversionService.addConverter(new StringToLocalTimeConverter());
        conversionService.addConverter(new LocalDateTimeToStringConverter());
        conversionService.addConverter(new StringToLocalDateTimeConverter());
        this.conversionService = conversionService;
    }

    public void setExitMessageLength(int exitMessageLength) {
        this.exitMessageLength = exitMessageLength;
    }

    public void setJobExecutionIncrementer(DataFieldMaxValueIncrementer jobExecutionIncrementer) {
        this.jobExecutionIncrementer = jobExecutionIncrementer;
    }

    public void setConversionService(@NonNull ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, "conversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state(this.jobExecutionIncrementer != null, "The jobExecutionIncrementer must not be null.");
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, "Job cannot be null.");
        Assert.notNull((Object)job.getId(), "Job Id cannot be null.");
        return this.getJdbcTemplate().query(this.getQuery(FIND_JOB_EXECUTIONS), new JobExecutionRowMapper(job), job.getId());
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        jobExecution.setId(this.jobExecutionIncrementer.nextLongValue());
        Timestamp startTime = jobExecution.getStartTime() == null ? null : Timestamp.valueOf(jobExecution.getStartTime());
        Timestamp endTime = jobExecution.getEndTime() == null ? null : Timestamp.valueOf(jobExecution.getEndTime());
        Timestamp createTime = jobExecution.getCreateTime() == null ? null : Timestamp.valueOf(jobExecution.getCreateTime());
        Timestamp lastUpdated = jobExecution.getLastUpdated() == null ? null : Timestamp.valueOf(jobExecution.getLastUpdated());
        Object[] parameters = new Object[]{jobExecution.getId(), jobExecution.getJobId(), startTime, endTime, jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), jobExecution.getExitStatus().getExitDescription(), jobExecution.getVersion(), createTime, lastUpdated};
        this.getJdbcTemplate().update(this.getQuery(SAVE_JOB_EXECUTION), parameters, new int[]{-5, -5, 93, 93, 12, 12, 12, 4, 93, 93});
        this.insertJobParameters(jobExecution.getId(), jobExecution.getJobParameters());
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, "jobExecution cannot be null");
        Assert.notNull((Object)jobExecution.getJobId(), "JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)jobExecution.getStatus(), "JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), "JobExecution create time cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        Assert.notNull((Object)jobExecution.getId(), "JobExecution ID cannot be null. JobExecution must be saved before it can be updated");
        Assert.notNull((Object)jobExecution.getVersion(), "JobExecution version cannot be null. JobExecution must be saved before it can be updated");
        this.lock.lock();
        try {
            Integer version = jobExecution.getVersion() + 1;
            String exitDescription = jobExecution.getExitStatus().getExitDescription();
            if (exitDescription != null && exitDescription.length() > this.exitMessageLength) {
                exitDescription = exitDescription.substring(0, this.exitMessageLength);
                if (logger.isDebugEnabled()) {
                    logger.debug("Truncating long message before update of JobExecution: " + jobExecution);
                }
            }
            Timestamp startTime = jobExecution.getStartTime() == null ? null : Timestamp.valueOf(jobExecution.getStartTime());
            Timestamp endTime = jobExecution.getEndTime() == null ? null : Timestamp.valueOf(jobExecution.getEndTime());
            Timestamp createTime = jobExecution.getCreateTime() == null ? null : Timestamp.valueOf(jobExecution.getCreateTime());
            Timestamp lastUpdated = jobExecution.getLastUpdated() == null ? null : Timestamp.valueOf(jobExecution.getLastUpdated());
            Object[] parameters = new Object[]{startTime, endTime, jobExecution.getStatus().toString(), jobExecution.getExitStatus().getExitCode(), exitDescription, version, createTime, lastUpdated, jobExecution.getId(), jobExecution.getVersion()};
            if (this.getJdbcTemplate().queryForObject(this.getQuery(CHECK_JOB_EXECUTION_EXISTS), Integer.class, jobExecution.getId()) != 1) {
                throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
            }
            int count = this.getJdbcTemplate().update(this.getQuery(UPDATE_JOB_EXECUTION), parameters, new int[]{93, 93, 12, 12, 12, 4, 93, 93, -5, 4});
            if (count == 0) {
                int currentVersion = this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, jobExecution.getId());
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + jobExecution.getId() + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + currentVersion);
            }
            jobExecution.incrementVersion();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @Nullable
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        Long id = jobInstance.getId();
        List<JobExecution> executions = this.getJdbcTemplate().query(this.getQuery(GET_LAST_EXECUTION), new JobExecutionRowMapper(jobInstance), id, id);
        Assert.state(executions.size() <= 1, "There must be at most one latest job execution");
        if (executions.isEmpty()) {
            return null;
        }
        return executions.get(0);
    }

    @Override
    @Nullable
    public JobExecution getJobExecution(Long executionId) {
        try {
            return this.getJdbcTemplate().queryForObject(this.getQuery(GET_EXECUTION_BY_ID), new JobExecutionRowMapper(), executionId);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        RowCallbackHandler handler = rs -> {
            JobExecutionRowMapper mapper = new JobExecutionRowMapper();
            result.add(mapper.mapRow(rs, 0));
        };
        this.getJdbcTemplate().query(this.getQuery(GET_RUNNING_EXECUTIONS), handler, jobName);
        return result;
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        int currentVersion = this.getJdbcTemplate().queryForObject(this.getQuery(CURRENT_VERSION_JOB_EXECUTION), Integer.class, jobExecution.getId());
        if (currentVersion != jobExecution.getVersion()) {
            String status = this.getJdbcTemplate().queryForObject(this.getQuery(GET_STATUS), String.class, jobExecution.getId());
            jobExecution.upgradeStatus(BatchStatus.valueOf(status));
            jobExecution.setVersion(currentVersion);
        }
    }

    @Override
    public void deleteJobExecution(JobExecution jobExecution) {
        this.getJdbcTemplate().update(this.getQuery(DELETE_JOB_EXECUTION), jobExecution.getId());
    }

    @Override
    public void deleteJobExecutionParameters(JobExecution jobExecution) {
        this.getJdbcTemplate().update(this.getQuery(DELETE_JOB_EXECUTION_PARAMETERS), jobExecution.getId());
    }

    private void insertJobParameters(Long executionId, JobParameters jobParameters) {
        if (jobParameters.isEmpty()) {
            return;
        }
        this.getJdbcTemplate().batchUpdate(this.getQuery(CREATE_JOB_PARAMETERS), jobParameters.getParameters().entrySet(), 100, (ps, entry) -> {
            JobParameter jobParameter = (JobParameter)entry.getValue();
            this.insertParameter(ps, executionId, jobParameter.getType(), (String)entry.getKey(), jobParameter.getValue(), jobParameter.isIdentifying());
        });
    }

    private <T> void insertParameter(PreparedStatement preparedStatement, Long executionId, Class<T> type, String key, T value, boolean identifying) throws SQLException {
        String identifyingFlag = identifying ? "Y" : "N";
        String stringValue = this.conversionService.convert(value, String.class);
        preparedStatement.setLong(1, executionId);
        preparedStatement.setString(2, key);
        preparedStatement.setString(3, type.getName());
        preparedStatement.setString(4, stringValue);
        preparedStatement.setString(5, identifyingFlag);
    }

    protected JobParameters getJobParameters(Long executionId) {
        HashMap map = new HashMap();
        RowCallbackHandler handler = rs -> {
            String parameterName = rs.getString("PARAMETER_NAME");
            Class<?> parameterType = null;
            try {
                parameterType = Class.forName(rs.getString("PARAMETER_TYPE"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            String stringValue = rs.getString("PARAMETER_VALUE");
            Object typedValue = this.conversionService.convert((Object)stringValue, parameterType);
            boolean identifying = rs.getString("IDENTIFYING").equalsIgnoreCase("Y");
            JobParameter jobParameter = new JobParameter(typedValue, parameterType, identifying);
            map.put(parameterName, jobParameter);
        };
        this.getJdbcTemplate().query(this.getQuery(FIND_PARAMS_FROM_ID), handler, executionId);
        return new JobParameters(map);
    }

    private final class JobExecutionRowMapper
    implements RowMapper<JobExecution> {
        private JobInstance jobInstance;

        public JobExecutionRowMapper() {
        }

        public JobExecutionRowMapper(JobInstance jobInstance) {
            this.jobInstance = jobInstance;
        }

        @Override
        public JobExecution mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long id = rs.getLong(1);
            JobParameters jobParameters = JdbcJobExecutionDao.this.getJobParameters(id);
            JobExecution jobExecution = this.jobInstance == null ? new JobExecution(id, jobParameters) : new JobExecution(this.jobInstance, id, jobParameters);
            jobExecution.setStartTime(rs.getTimestamp(2) == null ? null : rs.getTimestamp(2).toLocalDateTime());
            jobExecution.setEndTime(rs.getTimestamp(3) == null ? null : rs.getTimestamp(3).toLocalDateTime());
            jobExecution.setStatus(BatchStatus.valueOf(rs.getString(4)));
            jobExecution.setExitStatus(new ExitStatus(rs.getString(5), rs.getString(6)));
            jobExecution.setCreateTime(rs.getTimestamp(7) == null ? null : rs.getTimestamp(7).toLocalDateTime());
            jobExecution.setLastUpdated(rs.getTimestamp(8) == null ? null : rs.getTimestamp(8).toLocalDateTime());
            jobExecution.setVersion(rs.getInt(9));
            return jobExecution;
        }
    }
}

