/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.observability.BatchMetrics;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleChunkProcessor<I, O>
implements ChunkProcessor<I>,
InitializingBean {
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();
    protected MeterRegistry meterRegistry = Metrics.globalRegistry;

    private SimpleChunkProcessor() {
        this(null, null);
    }

    public SimpleChunkProcessor(@Nullable ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
    }

    public SimpleChunkProcessor(ItemWriter<? super O> itemWriter) {
        this(null, itemWriter);
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.itemWriter != null, "ItemWriter must be set");
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected MulticasterBatchListener<I, O> getListener() {
        return this.listener;
    }

    protected final O doProcess(I item) throws Exception {
        if (this.itemProcessor == null) {
            I result = item;
            return (O)result;
        }
        try {
            this.listener.beforeProcess(item);
            O result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected final void doWrite(Chunk<O> items) throws Exception {
        if (this.itemWriter == null) {
            return;
        }
        try {
            this.listener.beforeWrite(items);
            this.writeItems(items);
            this.doAfterWrite(items);
        }
        catch (Exception e) {
            this.doOnWriteError(e, items);
            throw e;
        }
    }

    protected final void doAfterWrite(Chunk<O> items) {
        this.listener.afterWrite(items);
    }

    protected final void doOnWriteError(Exception e, Chunk<O> items) {
        this.listener.onWriteError(e, items);
    }

    protected void writeItems(Chunk<O> items) throws Exception {
        if (this.itemWriter != null) {
            this.itemWriter.write(items);
        }
    }

    @Override
    public final void process(StepContribution contribution, Chunk<I> inputs) throws Exception {
        this.initializeUserData(inputs);
        if (this.isComplete(inputs)) {
            return;
        }
        Chunk<O> outputs = this.transform(contribution, inputs);
        contribution.incrementFilterCount(this.getFilterCount(inputs, outputs));
        this.write(contribution, inputs, this.getAdjustedOutputs(inputs, outputs));
    }

    protected void initializeUserData(Chunk<I> inputs) {
        inputs.setUserData(inputs.size());
    }

    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        return (Integer)inputs.getUserData() - outputs.size();
    }

    protected boolean isComplete(Chunk<I> inputs) {
        return inputs.isEmpty();
    }

    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        return outputs;
    }

    protected void write(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs) throws Exception {
        Timer.Sample sample = BatchMetrics.createTimerSample(this.meterRegistry);
        String status = "SUCCESS";
        try {
            this.doWrite(outputs);
        }
        catch (Exception e) {
            inputs.clear();
            status = "FAILURE";
            throw e;
        }
        finally {
            this.stopTimer(sample, contribution.getStepExecution(), "chunk.write", status, "Chunk writing");
        }
        contribution.incrementWriteCount(outputs.size());
    }

    protected Chunk<O> transform(StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk<Object> outputs = new Chunk<Object>(new Object[0]);
        Chunk.ChunkIterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            O output;
            Object item = iterator.next();
            Timer.Sample sample = BatchMetrics.createTimerSample(this.meterRegistry);
            String status = "SUCCESS";
            try {
                output = this.doProcess(item);
            }
            catch (Exception e) {
                inputs.clear();
                status = "FAILURE";
                throw e;
            }
            finally {
                this.stopTimer(sample, contribution.getStepExecution(), "item.process", status, "Item processing");
            }
            if (output != null) {
                outputs.add(output);
                continue;
            }
            iterator.remove();
        }
        if (inputs.isEnd()) {
            outputs.setEnd();
        }
        return outputs;
    }

    protected void stopTimer(Timer.Sample sample, StepExecution stepExecution, String metricName, String status, String description) {
        String fullyQualifiedMetricName = "spring.batch." + metricName;
        sample.stop(BatchMetrics.createTimer(this.meterRegistry, metricName, description + " duration", Tag.of(fullyQualifiedMetricName + ".job.name", stepExecution.getJobExecution().getJobInstance().getJobName()), Tag.of(fullyQualifiedMetricName + ".step.name", stepExecution.getStepName()), Tag.of(fullyQualifiedMetricName + ".status", status)));
    }
}

