/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.skip;

import java.util.Collections;
import java.util.Map;
import org.springframework.batch.core.step.skip.SkipLimitExceededException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;

public class LimitCheckingItemSkipPolicy
implements SkipPolicy {
    private long skipLimit;
    private Classifier<Throwable, Boolean> skippableExceptionClassifier;

    public LimitCheckingItemSkipPolicy() {
        this(0, Collections.emptyMap());
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Map<Class<? extends Throwable>, Boolean> skippableExceptions) {
        this(skipLimit, new BinaryExceptionClassifier(skippableExceptions));
    }

    public LimitCheckingItemSkipPolicy(int skipLimit, Classifier<Throwable, Boolean> skippableExceptionClassifier) {
        this.skipLimit = skipLimit;
        this.skippableExceptionClassifier = skippableExceptionClassifier;
    }

    public void setSkipLimit(long skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setSkippableExceptionClassifier(Classifier<Throwable, Boolean> skippableExceptionClassifier) {
        this.skippableExceptionClassifier = skippableExceptionClassifier;
    }

    public void setSkippableExceptionMap(Map<Class<? extends Throwable>, Boolean> skippableExceptions) {
        this.skippableExceptionClassifier = new BinaryExceptionClassifier(skippableExceptions);
    }

    @Override
    public boolean shouldSkip(Throwable t, long skipCount) {
        if (this.skippableExceptionClassifier.classify(t).booleanValue()) {
            if (skipCount < this.skipLimit) {
                return true;
            }
            throw new SkipLimitExceededException(this.skipLimit, t);
        }
        return false;
    }
}

