/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.StringUtils;

public class RepositoryItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private PagingAndSortingRepository<?, ?> repository;
    private Sort sort;
    private volatile int page = 0;
    private int pageSize = 10;
    private volatile int current = 0;
    private List<?> arguments;
    private volatile List<T> results;
    private final Lock lock = new ReentrantLock();
    private String methodName;

    public RepositoryItemReader() {
        this.setName(ClassUtils.getShortName(RepositoryItemReader.class));
    }

    public void setArguments(List<?> arguments) {
        this.arguments = arguments;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        this.sort = this.convertToSort(sorts);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRepository(PagingAndSortingRepository<?, ?> repository) {
        this.repository = repository;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.repository != null, "A PagingAndSortingRepository is required");
        Assert.state(this.pageSize > 0, "Page size must be greater than 0");
        Assert.state(this.sort != null, "A sort is required");
        Assert.state(this.methodName != null && !this.methodName.isEmpty(), "methodName is required.");
        if (this.isSaveState()) {
            Assert.state(StringUtils.hasText(this.getName()), "A name is required when saveState is set to true.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected T doRead() throws Exception {
        this.lock.lock();
        try {
            boolean nextPageNeeded;
            boolean bl = nextPageNeeded = this.results != null && this.current >= this.results.size();
            if (this.results == null || nextPageNeeded) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reading page " + this.page);
                }
                this.results = this.doPageRead();
                ++this.page;
                if (this.results.isEmpty()) {
                    T t = null;
                    return t;
                }
                if (nextPageNeeded) {
                    this.current = 0;
                }
            }
            if (this.current < this.results.size()) {
                T curLine = this.results.get(this.current);
                ++this.current;
                T t = curLine;
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void jumpToItem(int itemLastIndex) throws Exception {
        this.lock.lock();
        try {
            this.page = itemLastIndex / this.pageSize;
            this.current = itemLastIndex % this.pageSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected List<T> doPageRead() throws Exception {
        PageRequest pageRequest = PageRequest.of((int)this.page, (int)this.pageSize, (Sort)this.sort);
        MethodInvoker invoker = this.createMethodInvoker(this.repository, this.methodName);
        ArrayList<Object> parameters = new ArrayList<Object>();
        if (this.arguments != null && this.arguments.size() > 0) {
            parameters.addAll(this.arguments);
        }
        parameters.add(pageRequest);
        invoker.setArguments(parameters.toArray());
        Slice curPage = (Slice)this.doInvoke(invoker);
        return curPage.getContent();
    }

    @Override
    protected void doOpen() throws Exception {
    }

    @Override
    protected void doClose() throws Exception {
        this.lock.lock();
        try {
            this.current = 0;
            this.page = 0;
            this.results = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>();
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return Sort.by(sortValues);
    }

    private Object doInvoke(MethodInvoker invoker) throws Exception {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return invoker.invoke();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new AbstractMethodInvokingDelegator.InvocationTargetThrowableWrapper(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        return invoker;
    }
}

