/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import jakarta.persistence.EntityManagerFactory;
import org.springframework.batch.item.database.JpaItemWriter;
import org.springframework.util.Assert;

public class JpaItemWriterBuilder<T> {
    private EntityManagerFactory entityManagerFactory;
    private boolean usePersist = false;
    private boolean clearPersistenceContext = true;

    public JpaItemWriterBuilder<T> entityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        return this;
    }

    public JpaItemWriterBuilder<T> usePersist(boolean usePersist) {
        this.usePersist = usePersist;
        return this;
    }

    public JpaItemWriterBuilder<T> clearPersistenceContext(boolean clearPersistenceContext) {
        this.clearPersistenceContext = clearPersistenceContext;
        return this;
    }

    public JpaItemWriter<T> build() {
        Assert.state(this.entityManagerFactory != null, "EntityManagerFactory must be provided");
        JpaItemWriter writer = new JpaItemWriter();
        writer.setEntityManagerFactory(this.entityManagerFactory);
        writer.setUsePersist(this.usePersist);
        writer.setClearPersistenceContext(this.clearPersistenceContext);
        return writer;
    }
}

