/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.support;

import org.springframework.batch.item.database.support.AbstractSqlPagingQueryProvider;
import org.springframework.batch.item.database.support.SqlPagingQueryUtils;
import org.springframework.util.StringUtils;

public class SqlWindowingPagingQueryProvider
extends AbstractSqlPagingQueryProvider {
    @Override
    public String generateFirstPageQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append((String)(StringUtils.hasText(this.getOrderedQueryAlias()) ? this.getOrderedQueryAlias() + ".*, " : "*, "));
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause()).append((String)(this.getWhereClause() == null ? "" : " WHERE " + this.getWhereClause()));
        sql.append((String)(this.getGroupClause() == null ? "" : " GROUP BY " + this.getGroupClause()));
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        return sql.toString();
    }

    protected String getOrderedQueryAlias() {
        return "";
    }

    protected Object getSubQueryAlias() {
        return "AS TMP_SUB ";
    }

    protected Object extractTableAlias() {
        Object alias = String.valueOf(this.getSubQueryAlias());
        if (StringUtils.hasText((String)alias) && ((String)alias).toUpperCase().startsWith("AS")) {
            alias = ((String)alias).substring(3).trim() + ".";
        }
        return alias;
    }

    @Override
    public String generateRemainingPagesQuery(int pageSize) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM ( ");
        sql.append("SELECT ").append((String)(StringUtils.hasText(this.getOrderedQueryAlias()) ? this.getOrderedQueryAlias() + ".*, " : "*, "));
        sql.append("ROW_NUMBER() OVER (").append(this.getOverClause());
        sql.append(") AS ROW_NUMBER");
        sql.append(this.getOverSubstituteClauseStart());
        sql.append(" FROM ").append(this.getFromClause());
        if (this.getWhereClause() != null) {
            sql.append(" WHERE ");
            sql.append(this.getWhereClause());
        }
        sql.append((String)(this.getGroupClause() == null ? "" : " GROUP BY " + this.getGroupClause()));
        sql.append(this.getOverSubstituteClauseEnd());
        sql.append(") ").append(this.getSubQueryAlias()).append("WHERE ").append(this.extractTableAlias()).append("ROW_NUMBER <= ").append(pageSize);
        sql.append(" AND ");
        SqlPagingQueryUtils.buildSortConditions(this, sql);
        sql.append(" ORDER BY ").append(SqlPagingQueryUtils.buildSortClause(this));
        return sql.toString();
    }

    protected String getOverClause() {
        StringBuilder sql = new StringBuilder();
        sql.append(" ORDER BY ").append(this.buildSortClause(this));
        return sql.toString();
    }

    protected String getOverSubstituteClauseStart() {
        return "";
    }

    protected String getOverSubstituteClauseEnd() {
        return "";
    }

    private String buildSortClause(AbstractSqlPagingQueryProvider provider) {
        return SqlPagingQueryUtils.buildSortClause(provider.getSortKeysWithoutAliases());
    }
}

