/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.io.File;
import java.io.IOException;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.file.ResourceSuffixCreator;
import org.springframework.batch.item.file.SimpleResourceSuffixCreator;
import org.springframework.batch.item.support.AbstractItemStreamItemWriter;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MultiResourceItemWriter<T>
extends AbstractItemStreamItemWriter<T> {
    private static final String RESOURCE_INDEX_KEY = "resource.index";
    private static final String CURRENT_RESOURCE_ITEM_COUNT = "resource.item.count";
    private Resource resource;
    private ResourceAwareItemWriterItemStream<? super T> delegate;
    private int itemCountLimitPerResource = Integer.MAX_VALUE;
    private int currentResourceItemCount = 0;
    private int resourceIndex = 1;
    private ResourceSuffixCreator suffixCreator = new SimpleResourceSuffixCreator();
    private boolean saveState = true;
    private boolean opened = false;

    public MultiResourceItemWriter() {
        this.setExecutionContextName(ClassUtils.getShortName(MultiResourceItemWriter.class));
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        if (!this.opened) {
            File file = this.setResourceToDelegate();
            file.createNewFile();
            Assert.state(file.canWrite(), "Output resource " + file.getAbsolutePath() + " must be writable");
            this.delegate.open(new ExecutionContext());
            this.opened = true;
        }
        this.delegate.write(items);
        this.currentResourceItemCount += items.size();
        if (this.currentResourceItemCount >= this.itemCountLimitPerResource) {
            this.delegate.close();
            ++this.resourceIndex;
            this.currentResourceItemCount = 0;
            this.setResourceToDelegate();
            this.opened = false;
        }
    }

    public void setResourceSuffixCreator(ResourceSuffixCreator suffixCreator) {
        this.suffixCreator = suffixCreator;
    }

    public void setItemCountLimitPerResource(int itemCountLimitPerResource) {
        this.itemCountLimitPerResource = itemCountLimitPerResource;
    }

    public void setDelegate(ResourceAwareItemWriterItemStream<? super T> delegate) {
        this.delegate = delegate;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    @Override
    public void close() throws ItemStreamException {
        super.close();
        this.resourceIndex = 1;
        this.currentResourceItemCount = 0;
        if (this.opened) {
            this.delegate.close();
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.resourceIndex = executionContext.getInt(this.getExecutionContextKey(RESOURCE_INDEX_KEY), 1);
        this.currentResourceItemCount = executionContext.getInt(this.getExecutionContextKey(CURRENT_RESOURCE_ITEM_COUNT), 0);
        try {
            this.setResourceToDelegate();
        }
        catch (IOException e) {
            throw new ItemStreamException("Couldn't assign resource", e);
        }
        if (executionContext.containsKey(this.getExecutionContextKey(CURRENT_RESOURCE_ITEM_COUNT))) {
            this.delegate.open(executionContext);
            this.opened = true;
        } else {
            this.opened = false;
        }
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (this.saveState) {
            if (this.opened) {
                this.delegate.update(executionContext);
            }
            executionContext.putInt(this.getExecutionContextKey(CURRENT_RESOURCE_ITEM_COUNT), this.currentResourceItemCount);
            executionContext.putInt(this.getExecutionContextKey(RESOURCE_INDEX_KEY), this.resourceIndex);
        }
    }

    private File setResourceToDelegate() throws IOException {
        String path = this.resource.getFile().getAbsolutePath() + this.suffixCreator.getSuffix(this.resourceIndex);
        File file = new File(path);
        this.delegate.setResource(new FileSystemResource(file));
        return file;
    }
}

