/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import java.lang.reflect.Constructor;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.util.Assert;

public class RecordFieldSetMapper<T>
implements FieldSetMapper<T> {
    private final SimpleTypeConverter typeConverter = new SimpleTypeConverter();
    private final Constructor<T> mappedConstructor;
    private String[] constructorParameterNames;
    private Class<?>[] constructorParameterTypes;

    public RecordFieldSetMapper(Class<T> targetType) {
        this(targetType, new DefaultConversionService());
    }

    public RecordFieldSetMapper(Class<T> targetType, ConversionService conversionService) {
        this.typeConverter.setConversionService(conversionService);
        this.mappedConstructor = BeanUtils.getResolvableConstructor(targetType);
        if (this.mappedConstructor.getParameterCount() > 0) {
            this.constructorParameterNames = BeanUtils.getParameterNames(this.mappedConstructor);
            this.constructorParameterTypes = this.mappedConstructor.getParameterTypes();
        }
    }

    @Override
    public T mapFieldSet(FieldSet fieldSet) {
        Assert.isTrue(fieldSet.getFieldCount() == this.constructorParameterNames.length, "Fields count must be equal to record components count");
        Assert.isTrue(fieldSet.hasNames(), "Field names must specified");
        Object[] args = new Object[]{};
        if (this.constructorParameterNames != null && this.constructorParameterTypes != null) {
            args = new Object[this.constructorParameterNames.length];
            for (int i = 0; i < args.length; ++i) {
                String name = this.constructorParameterNames[i];
                Class<?> type = this.constructorParameterTypes[i];
                args[i] = this.typeConverter.convertIfNecessary(fieldSet.readRawString(name), type);
            }
        }
        return BeanUtils.instantiateClass(this.mappedConstructor, args);
    }
}

