/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.item.ItemReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SynchronizedItemReader<T>
implements ItemReader<T> {
    private final ItemReader<T> delegate;
    private final Lock lock = new ReentrantLock();

    public SynchronizedItemReader(ItemReader<T> delegate) {
        Assert.notNull(delegate, "The delegate must not be null");
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public T read() throws Exception {
        this.lock.lock();
        try {
            T t = this.delegate.read();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

