/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.util.Assert;

public class SynchronizedItemWriter<T>
implements ItemWriter<T> {
    private final ItemWriter<T> delegate;
    private final Lock lock = new ReentrantLock();

    public SynchronizedItemWriter(ItemWriter<T> delegate) {
        Assert.notNull(delegate, "The delegate must not be null");
        this.delegate = delegate;
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        this.lock.lock();
        try {
            this.delegate.write(items);
        }
        finally {
            this.lock.unlock();
        }
    }
}

