/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support.builder;

import org.springframework.batch.item.support.ScriptItemProcessor;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptItemProcessorBuilder<I, O> {
    private String language;
    private Resource scriptResource;
    private String scriptSource;
    private String itemBindingVariableName;

    public ScriptItemProcessorBuilder<I, O> scriptResource(Resource resource) {
        this.scriptResource = resource;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> language(String language) {
        this.language = language;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> scriptSource(String scriptSource) {
        this.scriptSource = scriptSource;
        return this;
    }

    public ScriptItemProcessorBuilder<I, O> itemBindingVariableName(String itemBindingVariableName) {
        this.itemBindingVariableName = itemBindingVariableName;
        return this;
    }

    public ScriptItemProcessor<I, O> build() {
        if (this.scriptResource == null && !StringUtils.hasText(this.scriptSource)) {
            throw new IllegalArgumentException("scriptResource or scriptSource is required.");
        }
        if (StringUtils.hasText(this.scriptSource)) {
            Assert.hasText(this.language, "language is required when using scriptSource.");
        }
        ScriptItemProcessor processor = new ScriptItemProcessor();
        if (StringUtils.hasText(this.itemBindingVariableName)) {
            processor.setItemBindingVariableName(this.itemBindingVariableName);
        }
        if (this.scriptResource != null) {
            processor.setScript(this.scriptResource);
        }
        if (this.scriptSource != null) {
            processor.setScriptSource(this.scriptSource, this.language);
        }
        return processor;
    }
}

