/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.ExpressionUtils;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.TypeCode;
import org.springframework.expression.spel.support.ReflectiveConstructorExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ConstructorReference
extends SpelNodeImpl {
    private static final int MAX_ARRAY_ELEMENTS = 262144;
    private final boolean isArrayConstructor;
    @Nullable
    private final SpelNodeImpl[] dimensions;
    @Nullable
    private volatile ConstructorExecutor cachedExecutor;

    public ConstructorReference(int startPos, int endPos, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.isArrayConstructor = false;
        this.dimensions = null;
    }

    public ConstructorReference(int startPos, int endPos, SpelNodeImpl[] dimensions, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.isArrayConstructor = true;
        this.dimensions = dimensions;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.isArrayConstructor) {
            return this.createArray(state);
        }
        return this.createNewInstance(state);
    }

    private TypedValue createNewInstance(ExpressionState state) throws EvaluationException {
        String typeName;
        Object[] arguments = new Object[this.getChildCount() - 1];
        ArrayList<TypeDescriptor> argumentTypes = new ArrayList<TypeDescriptor>(this.getChildCount() - 1);
        for (int i = 0; i < arguments.length; ++i) {
            Object value;
            TypedValue childValue = this.children[i + 1].getValueInternal(state);
            arguments[i] = value = childValue.getValue();
            argumentTypes.add(TypeDescriptor.forObject(value));
        }
        ConstructorExecutor executorToUse = this.cachedExecutor;
        if (executorToUse != null) {
            try {
                return executorToUse.execute(state.getEvaluationContext(), arguments);
            }
            catch (AccessException ex) {
                Throwable throwable = ex.getCause();
                if (throwable instanceof InvocationTargetException) {
                    InvocationTargetException cause = (InvocationTargetException)throwable;
                    Throwable rootCause = cause.getCause();
                    if (rootCause instanceof RuntimeException) {
                        RuntimeException runtimeException = (RuntimeException)rootCause;
                        throw runtimeException;
                    }
                    String typeName2 = (String)this.children[0].getValueInternal(state).getValue();
                    throw new SpelEvaluationException(this.getStartPosition(), rootCause, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName2, FormatHelper.formatMethodForMessage("", argumentTypes));
                }
                this.cachedExecutor = null;
            }
        }
        Assert.state((typeName = (String)this.children[0].getValueInternal(state).getValue()) != null, "No type name");
        executorToUse = this.findExecutorForConstructor(typeName, argumentTypes, state);
        try {
            this.cachedExecutor = executorToUse;
            if (executorToUse instanceof ReflectiveConstructorExecutor) {
                ReflectiveConstructorExecutor reflectiveConstructorExecutor = (ReflectiveConstructorExecutor)executorToUse;
                this.exitTypeDescriptor = CodeFlow.toDescriptor(reflectiveConstructorExecutor.getConstructor().getDeclaringClass());
            }
            return executorToUse.execute(state.getEvaluationContext(), arguments);
        }
        catch (AccessException ex) {
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
        }
    }

    private ConstructorExecutor findExecutorForConstructor(String typeName, List<TypeDescriptor> argumentTypes, ExpressionState state) throws SpelEvaluationException {
        EvaluationContext evalContext = state.getEvaluationContext();
        List<ConstructorResolver> ctorResolvers = evalContext.getConstructorResolvers();
        for (ConstructorResolver ctorResolver : ctorResolvers) {
            try {
                ConstructorExecutor ce = ctorResolver.resolve(state.getEvaluationContext(), typeName, argumentTypes);
                if (ce == null) continue;
                return ce;
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.CONSTRUCTOR_INVOCATION_PROBLEM, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
            }
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, typeName, FormatHelper.formatMethodForMessage("", argumentTypes));
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("new ");
        sb.append(this.getChild(0).toStringAST());
        if (this.isArrayConstructor) {
            if (this.hasInitializer()) {
                InlineList initializer = (InlineList)this.getChild(1);
                sb.append("[] ").append(initializer.toStringAST());
            } else if (this.dimensions != null) {
                for (SpelNodeImpl dimension : this.dimensions) {
                    sb.append('[').append(dimension.toStringAST()).append(']');
                }
            }
        } else {
            StringJoiner sj = new StringJoiner(",", "(", ")");
            int count = this.getChildCount();
            for (int i = 1; i < count; ++i) {
                sj.add(this.getChild(i).toStringAST());
            }
            sb.append(sj.toString());
        }
        return sb.toString();
    }

    private TypedValue createArray(ExpressionState state) throws EvaluationException {
        Object intendedArrayType = this.getChild(0).getValue(state);
        if (!(intendedArrayType instanceof String)) {
            throw new SpelEvaluationException(this.getChild(0).getStartPosition(), SpelMessage.TYPE_NAME_EXPECTED_FOR_ARRAY_CONSTRUCTION, FormatHelper.formatClassNameForMessage(intendedArrayType != null ? intendedArrayType.getClass() : null));
        }
        String type = (String)intendedArrayType;
        if (state.getEvaluationContext().getConstructorResolvers().isEmpty()) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CONSTRUCTOR_NOT_FOUND, type + "[]", "[]");
        }
        TypeCode arrayTypeCode = TypeCode.forName(type);
        Class<?> componentType = arrayTypeCode == TypeCode.OBJECT ? state.findType(type) : arrayTypeCode.getType();
        Object newArray = null;
        if (!this.hasInitializer()) {
            if (this.dimensions != null) {
                for (SpelNodeImpl dimension : this.dimensions) {
                    if (dimension != null) continue;
                    throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MISSING_ARRAY_DIMENSION, new Object[0]);
                }
                TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
                if (this.dimensions.length == 1) {
                    TypedValue o = this.dimensions[0].getTypedValue(state);
                    int arraySize = ExpressionUtils.toInt(typeConverter, o);
                    this.checkNumElements(arraySize);
                    newArray = Array.newInstance(componentType, arraySize);
                } else {
                    int[] dims = new int[this.dimensions.length];
                    long numElements = 1L;
                    for (int d = 0; d < this.dimensions.length; ++d) {
                        int arraySize;
                        TypedValue o = this.dimensions[d].getTypedValue(state);
                        dims[d] = arraySize = ExpressionUtils.toInt(typeConverter, o);
                        this.checkNumElements(numElements *= (long)arraySize);
                    }
                    newArray = Array.newInstance(componentType, dims);
                }
            }
        } else {
            TypedValue dValue;
            int i;
            if (this.dimensions == null || this.dimensions.length > 1) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MULTIDIM_ARRAY_INITIALIZER_NOT_SUPPORTED, new Object[0]);
            }
            TypeConverter typeConverter = state.getEvaluationContext().getTypeConverter();
            InlineList initializer = (InlineList)this.getChild(1);
            if (this.dimensions[0] != null && (i = ExpressionUtils.toInt(typeConverter, dValue = this.dimensions[0].getTypedValue(state))) != initializer.getChildCount()) {
                throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INITIALIZER_LENGTH_INCORRECT, new Object[0]);
            }
            newArray = switch (arrayTypeCode) {
                case TypeCode.OBJECT -> (Object)this.createReferenceTypeArray(state, typeConverter, initializer.children, componentType);
                case TypeCode.BOOLEAN -> this.createBooleanArray(state, typeConverter, initializer.children);
                case TypeCode.CHAR -> (Object)this.createCharArray(state, typeConverter, initializer.children);
                case TypeCode.BYTE -> (Object)this.createByteArray(state, typeConverter, initializer.children);
                case TypeCode.SHORT -> (Object)this.createShortArray(state, typeConverter, initializer.children);
                case TypeCode.INT -> (Object)this.createIntArray(state, typeConverter, initializer.children);
                case TypeCode.LONG -> (Object)this.createLongArray(state, typeConverter, initializer.children);
                case TypeCode.FLOAT -> (Object)this.createFloatArray(state, typeConverter, initializer.children);
                case TypeCode.DOUBLE -> (Object)this.createDoubleArray(state, typeConverter, initializer.children);
                default -> throw new IllegalStateException("Unsupported TypeCode: " + String.valueOf((Object)arrayTypeCode));
            };
        }
        return new TypedValue(newArray);
    }

    private void checkNumElements(long numElements) {
        if (numElements >= 262144L) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.MAX_ARRAY_ELEMENTS_THRESHOLD_EXCEEDED, 262144);
        }
    }

    private Object createReferenceTypeArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children, Class<?> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, children.length);
        TypeDescriptor targetType = TypeDescriptor.valueOf(componentType);
        for (int i = 0; i < array.length; ++i) {
            Object value = children[i].getValue(state);
            array[i] = typeConverter.convertValue(value, TypeDescriptor.forObject(value), targetType);
        }
        return array;
    }

    private boolean[] createBooleanArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        boolean[] array = new boolean[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toBoolean(typeConverter, typedValue);
        }
        return array;
    }

    private char[] createCharArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        char[] array = new char[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toChar(typeConverter, typedValue);
        }
        return array;
    }

    private byte[] createByteArray(ExpressionState state, TypeConverter converter, SpelNodeImpl[] children) {
        byte[] array = new byte[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toByte(converter, typedValue);
        }
        return array;
    }

    private short[] createShortArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        short[] array = new short[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toShort(typeConverter, typedValue);
        }
        return array;
    }

    private int[] createIntArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        int[] array = new int[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toInt(typeConverter, typedValue);
        }
        return array;
    }

    private long[] createLongArray(ExpressionState state, TypeConverter converter, SpelNodeImpl[] children) {
        long[] array = new long[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toLong(converter, typedValue);
        }
        return array;
    }

    private float[] createFloatArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        float[] array = new float[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toFloat(typeConverter, typedValue);
        }
        return array;
    }

    private double[] createDoubleArray(ExpressionState state, TypeConverter typeConverter, SpelNodeImpl[] children) {
        double[] array = new double[children.length];
        for (int i = 0; i < array.length; ++i) {
            TypedValue typedValue = children[i].getTypedValue(state);
            array[i] = ExpressionUtils.toDouble(typeConverter, typedValue);
        }
        return array;
    }

    private boolean hasInitializer() {
        return this.getChildCount() > 1;
    }

    @Override
    public boolean isCompilable() {
        ReflectiveConstructorExecutor executor;
        block4: {
            block3: {
                ConstructorExecutor constructorExecutor = this.cachedExecutor;
                if (!(constructorExecutor instanceof ReflectiveConstructorExecutor)) break block3;
                executor = (ReflectiveConstructorExecutor)constructorExecutor;
                if (this.exitTypeDescriptor != null) break block4;
            }
            return false;
        }
        for (int i = 1; i < this.children.length; ++i) {
            if (this.children[i].isCompilable()) continue;
            return false;
        }
        Constructor<?> constructor = executor.getConstructor();
        return Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(constructor.getDeclaringClass().getModifiers());
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        ReflectiveConstructorExecutor executor = (ReflectiveConstructorExecutor)this.cachedExecutor;
        Assert.state(executor != null, "No cached executor");
        Constructor<?> constructor = executor.getConstructor();
        String classDesc = constructor.getDeclaringClass().getName().replace('.', '/');
        mv.visitTypeInsn(187, classDesc);
        mv.visitInsn(89);
        SpelNodeImpl[] arguments = new SpelNodeImpl[this.children.length - 1];
        System.arraycopy(this.children, 1, arguments, 0, this.children.length - 1);
        ConstructorReference.generateCodeForArguments(mv, cf, constructor, arguments);
        mv.visitMethodInsn(183, classDesc, "<init>", CodeFlow.createSignatureDescriptor(constructor), false);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }
}

