/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import javax.sql.DataSource;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jdbc.ConnectionStrategy;
import org.apache.camel.component.jdbc.JdbcComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JdbcComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JdbcComponent target = (JdbcComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(JdbcComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                target.setConnectionStrategy(JdbcComponentConfigurer.property(camelContext, ConnectionStrategy.class, value));
                return true;
            }
            case "datasource": 
            case "dataSource": {
                target.setDataSource(JdbcComponentConfigurer.property(camelContext, DataSource.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JdbcComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                return ConnectionStrategy.class;
            }
            case "datasource": 
            case "dataSource": {
                return DataSource.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JdbcComponent target = (JdbcComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                return target.getConnectionStrategy();
            }
            case "datasource": 
            case "dataSource": {
                return target.getDataSource();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
        }
        return null;
    }
}

