/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jdbc;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jdbc.BeanRowMapper;
import org.apache.camel.component.jdbc.ConnectionStrategy;
import org.apache.camel.component.jdbc.JdbcEndpoint;
import org.apache.camel.component.jdbc.JdbcOutputType;
import org.apache.camel.component.jdbc.JdbcPrepareStatementStrategy;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class JdbcEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        JdbcEndpoint target = (JdbcEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownamedparameters": 
            case "allowNamedParameters": {
                target.setAllowNamedParameters(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "beanrowmapper": 
            case "beanRowMapper": {
                target.setBeanRowMapper(JdbcEndpointConfigurer.property(camelContext, BeanRowMapper.class, value));
                return true;
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                target.setConnectionStrategy(JdbcEndpointConfigurer.property(camelContext, ConnectionStrategy.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "outputclass": 
            case "outputClass": {
                target.setOutputClass(JdbcEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "outputtype": 
            case "outputType": {
                target.setOutputType(JdbcEndpointConfigurer.property(camelContext, JdbcOutputType.class, value));
                return true;
            }
            case "parameters": {
                target.setParameters(JdbcEndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "preparestatementstrategy": 
            case "prepareStatementStrategy": {
                target.setPrepareStatementStrategy(JdbcEndpointConfigurer.property(camelContext, JdbcPrepareStatementStrategy.class, value));
                return true;
            }
            case "readsize": 
            case "readSize": {
                target.setReadSize(JdbcEndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "resetautocommit": 
            case "resetAutoCommit": {
                target.setResetAutoCommit(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "transacted": {
                target.setTransacted(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "usegetbytesforblob": 
            case "useGetBytesForBlob": {
                target.setUseGetBytesForBlob(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "useheadersasparameters": 
            case "useHeadersAsParameters": {
                target.setUseHeadersAsParameters(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "usejdbc4columnnameandlabelsemantics": 
            case "useJDBC4ColumnNameAndLabelSemantics": {
                target.setUseJDBC4ColumnNameAndLabelSemantics(JdbcEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownamedparameters": 
            case "allowNamedParameters": {
                return Boolean.TYPE;
            }
            case "beanrowmapper": 
            case "beanRowMapper": {
                return BeanRowMapper.class;
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                return ConnectionStrategy.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "outputclass": 
            case "outputClass": {
                return String.class;
            }
            case "outputtype": 
            case "outputType": {
                return JdbcOutputType.class;
            }
            case "parameters": {
                return Map.class;
            }
            case "preparestatementstrategy": 
            case "prepareStatementStrategy": {
                return JdbcPrepareStatementStrategy.class;
            }
            case "readsize": 
            case "readSize": {
                return Integer.TYPE;
            }
            case "resetautocommit": 
            case "resetAutoCommit": {
                return Boolean.TYPE;
            }
            case "transacted": {
                return Boolean.TYPE;
            }
            case "usegetbytesforblob": 
            case "useGetBytesForBlob": {
                return Boolean.TYPE;
            }
            case "useheadersasparameters": 
            case "useHeadersAsParameters": {
                return Boolean.TYPE;
            }
            case "usejdbc4columnnameandlabelsemantics": 
            case "useJDBC4ColumnNameAndLabelSemantics": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        JdbcEndpoint target = (JdbcEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "allownamedparameters": 
            case "allowNamedParameters": {
                return target.isAllowNamedParameters();
            }
            case "beanrowmapper": 
            case "beanRowMapper": {
                return target.getBeanRowMapper();
            }
            case "connectionstrategy": 
            case "connectionStrategy": {
                return target.getConnectionStrategy();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "outputclass": 
            case "outputClass": {
                return target.getOutputClass();
            }
            case "outputtype": 
            case "outputType": {
                return target.getOutputType();
            }
            case "parameters": {
                return target.getParameters();
            }
            case "preparestatementstrategy": 
            case "prepareStatementStrategy": {
                return target.getPrepareStatementStrategy();
            }
            case "readsize": 
            case "readSize": {
                return target.getReadSize();
            }
            case "resetautocommit": 
            case "resetAutoCommit": {
                return target.isResetAutoCommit();
            }
            case "transacted": {
                return target.isTransacted();
            }
            case "usegetbytesforblob": 
            case "useGetBytesForBlob": {
                return target.isUseGetBytesForBlob();
            }
            case "useheadersasparameters": 
            case "useHeadersAsParameters": {
                return target.isUseHeadersAsParameters();
            }
            case "usejdbc4columnnameandlabelsemantics": 
            case "useJDBC4ColumnNameAndLabelSemantics": {
                return target.isUseJDBC4ColumnNameAndLabelSemantics();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "parameters": {
                return Object.class;
            }
        }
        return null;
    }
}

