/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.util.function.UnaryOperator;
import org.springframework.jdbc.datasource.embedded.DerbyEmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.embedded.H2EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.HsqlEmbeddedDatabaseConfigurer;
import org.springframework.util.Assert;

public abstract class EmbeddedDatabaseConfigurers {
    public static EmbeddedDatabaseConfigurer getConfigurer(EmbeddedDatabaseType type) {
        Assert.notNull((Object)type, "EmbeddedDatabaseType is required");
        try {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case EmbeddedDatabaseType.HSQL -> HsqlEmbeddedDatabaseConfigurer.getInstance();
                case EmbeddedDatabaseType.H2 -> H2EmbeddedDatabaseConfigurer.getInstance();
                case EmbeddedDatabaseType.DERBY -> DerbyEmbeddedDatabaseConfigurer.getInstance();
            };
        }
        catch (ClassNotFoundException | NoClassDefFoundError ex) {
            throw new IllegalStateException("Driver for test database type [" + String.valueOf((Object)type) + "] is not available", ex);
        }
    }

    public static EmbeddedDatabaseConfigurer customizeConfigurer(EmbeddedDatabaseType type, UnaryOperator<EmbeddedDatabaseConfigurer> customizer) {
        EmbeddedDatabaseConfigurer defaultConfigurer = EmbeddedDatabaseConfigurers.getConfigurer(type);
        return (EmbeddedDatabaseConfigurer)customizer.apply(defaultConfigurer);
    }
}

