/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.schema;

import javax.naming.NamingException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.springframework.ldap.core.LdapAttributes;
import org.springframework.ldap.schema.Specification;
import org.springframework.ldap.support.LdapEncoder;

public class BasicSchemaSpecification
implements Specification<LdapAttributes> {
    @Override
    public boolean isSatisfiedBy(LdapAttributes record) throws NamingException {
        Rdn rdn;
        LdapName dn;
        if (record != null && (dn = record.getName()) != null && record.get("objectClass") != null && record.get((rdn = dn.getRdn(dn.size() - 1)).getType()) != null) {
            String attributeValue;
            String rdnValue;
            Object object = record.get(rdn.getType()).get();
            if (object instanceof String) {
                String value = (String)object;
                if (((String)rdn.getValue()).equalsIgnoreCase(value)) {
                    return true;
                }
            } else if (object instanceof byte[] && (rdnValue = LdapEncoder.printBase64Binary(((String)rdn.getValue()).getBytes())).equals(attributeValue = LdapEncoder.printBase64Binary((byte[])object))) {
                return true;
            }
        }
        return false;
    }
}

