/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import org.springframework.util.StringUtils;

public final class AttributeSchema {
    private final String name;
    private final String syntax;
    private final boolean isMultiValued;
    private final boolean isPrimitive;
    private final String scalarType;
    private final boolean isBinary;
    private final boolean isArray;

    public AttributeSchema(String name, String syntax, boolean isMultiValued, boolean isPrimitive, boolean isBinary, boolean isArray, String scalarType) {
        this.name = name;
        this.syntax = syntax;
        this.isMultiValued = isMultiValued;
        this.isPrimitive = isPrimitive;
        this.scalarType = scalarType;
        this.isBinary = isBinary;
        this.isArray = isArray;
    }

    public boolean getIsArray() {
        return this.isArray;
    }

    public boolean getIsBinary() {
        return this.isBinary;
    }

    public boolean getIsPrimitive() {
        return this.isPrimitive;
    }

    public String getScalarType() {
        return this.scalarType;
    }

    public String getName() {
        return this.name;
    }

    public String getJavaName() {
        return StringUtils.replace(this.name, "-", "");
    }

    public String getSyntax() {
        return this.syntax;
    }

    public boolean getIsMultiValued() {
        return this.isMultiValued;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeSchema other = (AttributeSchema)obj;
        if (this.isArray != other.isArray) {
            return false;
        }
        if (this.isBinary != other.isBinary) {
            return false;
        }
        if (this.isMultiValued != other.isMultiValued) {
            return false;
        }
        if (this.isPrimitive != other.isPrimitive) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.scalarType == null ? other.scalarType != null : !this.scalarType.equals(other.scalarType)) {
            return false;
        }
        return !(this.syntax == null ? other.syntax != null : !this.syntax.equals(other.syntax));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isArray ? 1231 : 1237);
        result = 31 * result + (this.isBinary ? 1231 : 1237);
        result = 31 * result + (this.isMultiValued ? 1231 : 1237);
        result = 31 * result + (this.isPrimitive ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.scalarType == null ? 0 : this.scalarType.hashCode());
        result = 31 * result + (this.syntax == null ? 0 : this.syntax.hashCode());
        return result;
    }

    public String toString() {
        return String.format("{ name=%1$s, syntax=%2$s, isMultiValued=%3$s, isPrimitive=%4$s, isBinary=%5$s, isArray=%6$s, scalarType=%7$s }", this.name, this.syntax, this.isMultiValued, this.isPrimitive, this.isBinary, this.isArray, this.scalarType);
    }
}

