/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.ldap.odm.tools.AttributeSchema;

public final class ObjectSchema {
    private final Set<AttributeSchema> must = new HashSet<AttributeSchema>();
    private final Set<AttributeSchema> may = new HashSet<AttributeSchema>();
    private final Set<String> objectClass = new HashSet<String>();

    public void addMust(AttributeSchema must) {
        if (this.may.contains(must)) {
            this.may.remove(must);
        }
        this.must.add(must);
    }

    public void addMay(AttributeSchema may) {
        if (!this.must.contains(may)) {
            this.may.add(may);
        }
    }

    public void addObjectClass(String objectClass) {
        this.objectClass.add(objectClass);
    }

    public Set<AttributeSchema> getMust() {
        return Collections.unmodifiableSet(this.must);
    }

    public Set<AttributeSchema> getMay() {
        return Collections.unmodifiableSet(this.may);
    }

    public Set<String> getObjectClass() {
        return Collections.unmodifiableSet(this.objectClass);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectSchema other = (ObjectSchema)obj;
        if (this.may == null ? other.may != null : !this.may.equals(other.may)) {
            return false;
        }
        if (this.must == null ? other.must != null : !this.must.equals(other.must)) {
            return false;
        }
        return !(this.objectClass == null ? other.objectClass != null : !this.objectClass.equals(other.objectClass));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.may == null ? 0 : this.may.hashCode());
        result = 31 * result + (this.must == null ? 0 : this.must.hashCode());
        result = 31 * result + (this.objectClass == null ? 0 : this.objectClass.hashCode());
        return result;
    }

    public String toString() {
        return String.format("objectClass=%1$s | must=%2$s | may=%3$s", this.objectClass, this.must, this.may);
    }
}

