/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.springframework.ldap.odm.tools.AttributeSchema;
import org.springframework.ldap.odm.tools.ObjectSchema;
import org.springframework.ldap.odm.tools.SyntaxToJavaClass;

final class SchemaReader {
    private final DirContext schemaContext;
    private final SyntaxToJavaClass syntaxToJavaClass;
    private final Set<String> binarySet;

    SchemaReader(DirContext schemaContext, SyntaxToJavaClass syntaxToJavaClass, Set<String> binarySet) {
        this.schemaContext = schemaContext;
        this.syntaxToJavaClass = syntaxToJavaClass;
        this.binarySet = binarySet;
    }

    ObjectSchema getObjectSchema(Set<String> objectClasses) throws NamingException, ClassNotFoundException {
        ObjectSchema result = new ObjectSchema();
        this.createObjectClass(objectClasses, this.schemaContext, result);
        return result;
    }

    private SchemaAttributeType getSchemaAttributeType(String type) {
        SchemaAttributeType result = SchemaAttributeType.UNKNOWN;
        if (type.equals("SUP")) {
            result = SchemaAttributeType.SUP;
        } else if (type.equals("MUST")) {
            result = SchemaAttributeType.MUST;
        } else if (type.equals("MAY")) {
            result = SchemaAttributeType.MAY;
        }
        return result;
    }

    private AttributeSchema createAttributeSchema(String name, DirContext schemaContext) throws NamingException, ClassNotFoundException {
        Attributes attributeSchema = schemaContext.getAttributes("AttributeDefinition/" + name);
        String syntax = null;
        while (syntax == null) {
            Attribute syntaxAttribute = attributeSchema.get("SYNTAX");
            if (syntaxAttribute != null) {
                syntax = ((String)syntaxAttribute.get()).split("\\{")[0];
                continue;
            }
            Attribute supAttribute = attributeSchema.get("SUP");
            if (supAttribute == null) {
                throw new IllegalArgumentException("Unable to get syntax definition for attribute " + name);
            }
            attributeSchema = schemaContext.getAttributes("AttributeDefinition/" + supAttribute.get());
        }
        boolean isBinary = this.binarySet.contains(syntax);
        SyntaxToJavaClass.ClassInfo classInfo = this.syntaxToJavaClass.getClassInfo(syntax);
        String javaClassName = null;
        boolean isPrimitive = false;
        boolean isArray = false;
        if (classInfo != null) {
            javaClassName = classInfo.getClassName();
            Class<?> javaClass = Class.forName(classInfo.getFullClassName());
            javaClassName = javaClass.getSimpleName();
            isPrimitive = javaClass.isPrimitive();
            isArray = javaClass.isArray();
        } else if (isBinary) {
            javaClassName = "byte[]";
            isPrimitive = false;
            isArray = true;
        } else {
            javaClassName = "String";
            isPrimitive = false;
            isArray = false;
        }
        return new AttributeSchema(name, syntax, attributeSchema.get("SINGLE-VALUE") == null, isPrimitive, isBinary, isArray, javaClassName);
    }

    private void createObjectClass(Set<String> objectClasses, DirContext schemaContext, ObjectSchema schema) throws NamingException, ClassNotFoundException {
        HashSet<String> supList = new HashSet<String>();
        for (String objectClass : objectClasses) {
            schema.addObjectClass(objectClass);
            Attributes attributes = schemaContext.getAttributes("ClassDefinition/" + objectClass);
            NamingEnumeration<? extends Attribute> valuesEnumeration = attributes.getAll();
            while (valuesEnumeration.hasMoreElements()) {
                Attribute currentAttribute = (Attribute)valuesEnumeration.nextElement();
                String currentId = currentAttribute.getID().toUpperCase();
                SchemaAttributeType type = this.getSchemaAttributeType(currentId);
                NamingEnumeration<?> currentValues = currentAttribute.getAll();
                while (currentValues.hasMoreElements()) {
                    String currentValue = (String)currentValues.nextElement();
                    switch (type) {
                        case SUP: {
                            String lowerCased = currentValue.toLowerCase();
                            if (schema.getObjectClass().contains(lowerCased)) break;
                            supList.add(lowerCased);
                            break;
                        }
                        case MUST: {
                            schema.addMust(this.createAttributeSchema(currentValue, schemaContext));
                            break;
                        }
                        case MAY: {
                            schema.addMay(this.createAttributeSchema(currentValue, schemaContext));
                            break;
                        }
                    }
                }
            }
            this.createObjectClass(supList, schemaContext, schema);
        }
    }

    private static enum SchemaAttributeType {
        SUP,
        MUST,
        MAY,
        UNKNOWN;

    }
}

