/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.util.IOHelper;

public class ByteArrayInputStreamCache
extends FilterInputStream
implements StreamCache {
    private final ByteArrayInputStream bais;
    private final int length;
    private byte[] byteArrayForCopy;

    public ByteArrayInputStreamCache(ByteArrayInputStream in) {
        super(in);
        this.bais = in;
        this.length = in.available();
    }

    @Override
    public synchronized void reset() {
        try {
            super.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        IOHelper.copyAndCloseInput(this.in, os);
    }

    @Override
    public StreamCache copy(Exchange exchange) throws IOException {
        if (this.byteArrayForCopy == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.in.available());
            IOHelper.copy(this.in, baos);
            this.reset();
            this.byteArrayForCopy = baos.toByteArray();
        }
        return new InputStreamCache(this.byteArrayForCopy);
    }

    @Override
    public boolean inMemory() {
        return true;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long position() {
        return this.length - this.bais.available();
    }
}

