/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.simple.SimpleExpressionParser;
import org.apache.camel.language.simple.SimplePredicateParser;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.LRUCache;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Language(value="simple")
public class SimpleLanguage
extends LanguageSupport
implements StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLanguage.class);
    private static final SimpleLanguage SIMPLE = new SimpleLanguage();
    private static final String CACHE_KEY_PREFIX = "@SIMPLE@";
    boolean allowEscape = true;
    private Map<String, Expression> cacheExpression;
    private Map<String, Predicate> cachePredicate;

    @Override
    public void init() {
        if (this.cacheExpression == null && this.cachePredicate == null && this.getCamelContext() != null) {
            int maxSize = CamelContextHelper.getMaximumSimpleCacheSize(this.getCamelContext());
            if (maxSize > 0) {
                this.cacheExpression = LRUCacheFactory.newLRUCache(16, maxSize, false);
                this.cachePredicate = LRUCacheFactory.newLRUCache(16, maxSize, false);
                LOG.debug("Simple language predicate/expression cache size: {}", (Object)maxSize);
            } else {
                LOG.debug("Simple language disabled predicate/expression cache");
            }
        }
    }

    @Override
    public void start() {
        if (this.getCamelContext() != null) {
            SIMPLE.setCamelContext(this.getCamelContext());
        }
    }

    @Override
    public void stop() {
        LRUCache cache;
        Map<String, Object> map = this.cachePredicate;
        if (map instanceof LRUCache) {
            cache = (LRUCache)map;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing simple language predicate cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
            }
            this.cachePredicate.clear();
        }
        if ((map = this.cacheExpression) instanceof LRUCache) {
            cache = (LRUCache)map;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing simple language expression cache[size={}, hits={}, misses={}, evicted={}]", new Object[]{cache.size(), cache.getHits(), cache.getMisses(), cache.getEvicted()});
            }
            this.cacheExpression.clear();
        }
    }

    @Override
    public Predicate createPredicate(String expression) {
        Predicate answer;
        ObjectHelper.notNull(expression, "expression");
        String key = CACHE_KEY_PREFIX + expression;
        Predicate predicate = answer = this.cachePredicate != null ? this.cachePredicate.get(key) : null;
        if (answer == null) {
            if (this.isDynamicResource(expression)) {
                final String text = expression;
                return new Predicate(){

                    @Override
                    public boolean matches(Exchange exchange) {
                        String r = ScriptHelper.resolveOptionalExternalScript(SimpleLanguage.this.getCamelContext(), exchange, text);
                        Predicate pred = SimpleLanguage.this.createPredicate(r);
                        pred.init(SimpleLanguage.this.getCamelContext());
                        return pred.matches(exchange);
                    }

                    public String toString() {
                        return text;
                    }
                };
            }
            if (this.isStaticResource(expression)) {
                expression = this.loadResource(expression);
                key = CACHE_KEY_PREFIX + expression;
            }
            SimplePredicateParser parser = new SimplePredicateParser(this.getCamelContext(), expression, this.allowEscape, this.cacheExpression);
            answer = parser.parsePredicate();
            if (this.cachePredicate != null && answer != null) {
                this.cachePredicate.put(key, answer);
            }
        }
        return answer;
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        boolean trim = this.property(Boolean.TYPE, properties, 1, true);
        if (trim && expression != null) {
            expression = expression.trim();
        }
        if (expression == null) {
            expression = "${null}";
        }
        return this.createPredicate(expression);
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        Class resultType = this.property(Class.class, properties, 0, null);
        boolean trim = this.property(Boolean.TYPE, properties, 1, true);
        if (trim && expression != null) {
            expression = expression.trim();
        }
        if (expression == null) {
            expression = "${null}";
        }
        return this.createExpression(expression, resultType);
    }

    @Override
    public Expression createExpression(String expression) {
        Expression answer;
        ObjectHelper.notNull(expression, "expression");
        String key = CACHE_KEY_PREFIX + expression;
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(key) : null;
        if (answer == null) {
            if (this.isDynamicResource(expression)) {
                final String text = expression;
                return new Expression(){

                    @Override
                    public <T> T evaluate(Exchange exchange, Class<T> type) {
                        String r = ScriptHelper.resolveOptionalExternalScript(SimpleLanguage.this.getCamelContext(), exchange, text);
                        Expression exp = SimpleLanguage.this.createExpression(r);
                        exp.init(SimpleLanguage.this.getCamelContext());
                        return exp.evaluate(exchange, type);
                    }

                    public String toString() {
                        return text;
                    }
                };
            }
            if (this.isStaticResource(expression)) {
                expression = this.loadResource(expression);
                key = CACHE_KEY_PREFIX + expression;
            }
            SimpleExpressionParser parser = new SimpleExpressionParser(this.getCamelContext(), expression, this.allowEscape, this.cacheExpression);
            answer = parser.parseExpression();
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(key, answer);
            }
        }
        return answer;
    }

    public Expression createExpression(String expression, Class<?> resultType) {
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = this.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression(predicate);
        }
        Expression exp = this.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression(exp, resultType);
        }
        return exp;
    }
}

