/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.types.BinaryOperatorType;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.builder.PredicateBuilder;
import org.apache.camel.support.builder.ValueBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class BinaryExpression
extends BaseSimpleNode {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)(\\.\\.)(\\d+)$");
    private final BinaryOperatorType operator;
    private SimpleNode left;
    private SimpleNode right;

    public BinaryExpression(SimpleToken token) {
        super(token);
        this.operator = BinaryOperatorType.asOperator(token.getText());
    }

    @Override
    public String toString() {
        return String.valueOf(this.left) + " " + this.token.getText() + " " + String.valueOf(this.right);
    }

    public boolean acceptLeftNode(SimpleNode lef) {
        this.left = lef;
        return true;
    }

    public boolean acceptRightNode(SimpleNode right) {
        this.right = right;
        return true;
    }

    public BinaryOperatorType getOperator() {
        return this.operator;
    }

    public SimpleNode getLeft() {
        return this.left;
    }

    public SimpleNode getRight() {
        return this.right;
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        ObjectHelper.notNull(this.left, "left node", this);
        ObjectHelper.notNull(this.right, "right node", this);
        Expression leftExp = this.left.createExpression(camelContext, expression);
        Expression rightExp = this.right.createExpression(camelContext, expression);
        if (this.operator == BinaryOperatorType.EQ) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isEqualTo(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.EQ_IGNORE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isEqualToIgnoreCase(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.GT) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isGreaterThan(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.GTE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isGreaterThanOrEqualTo(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.LT) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isLessThan(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.LTE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isLessThanOrEqualTo(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_EQ) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.isNotEqualTo(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_EQ_IGNORE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.not(PredicateBuilder.isEqualToIgnoreCase(leftExp, rightExp)));
        }
        if (this.operator == BinaryOperatorType.CONTAINS) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.contains(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.not(PredicateBuilder.contains(leftExp, rightExp)));
        }
        if (this.operator == BinaryOperatorType.CONTAINS_IGNORECASE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.containsIgnoreCase(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS_IGNORECASE) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.not(PredicateBuilder.containsIgnoreCase(leftExp, rightExp)));
        }
        if (this.operator == BinaryOperatorType.IS || this.operator == BinaryOperatorType.NOT_IS) {
            return this.createIsExpression(camelContext, expression, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.REGEX || this.operator == BinaryOperatorType.NOT_REGEX) {
            return this.createRegexExpression(camelContext, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.IN || this.operator == BinaryOperatorType.NOT_IN) {
            return this.createInExpression(camelContext, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.RANGE || this.operator == BinaryOperatorType.NOT_RANGE) {
            return this.createRangeExpression(camelContext, expression, leftExp, rightExp);
        }
        if (this.operator == BinaryOperatorType.STARTS_WITH) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.startsWith(leftExp, rightExp));
        }
        if (this.operator == BinaryOperatorType.ENDS_WITH) {
            return this.createExpression(camelContext, leftExp, rightExp, PredicateBuilder.endsWith(leftExp, rightExp));
        }
        throw new SimpleParserException("Unknown binary operator " + String.valueOf((Object)this.operator), this.token.getIndex());
    }

    private Expression createIsExpression(final CamelContext camelContext, final String expression, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Class<?> rightType;
                String name = rightExp.evaluate(exchange, String.class);
                if (name == null || "null".equals(name)) {
                    this.throwMissingClass();
                }
                if ((rightType = camelContext.getClassResolver().resolveClass(name)) == null) {
                    this.throwClassNotFound(name);
                }
                Predicate predicate = PredicateBuilder.isInstanceOf(leftExp, rightType);
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_IS) {
                    predicate = PredicateBuilder.not(predicate);
                }
                boolean answer = predicate.matches(exchange);
                return camelContext.getTypeConverter().convertTo(type, answer);
            }

            private void throwClassNotFound(String name) {
                throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), String.valueOf((Object)BinaryExpression.this.operator) + " operator cannot find class with name: " + name);
            }

            private void throwMissingClass() {
                throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), String.valueOf((Object)BinaryExpression.this.operator) + " operator cannot accept null. A class type must be provided.");
            }

            public String toString() {
                return String.valueOf(BinaryExpression.this.left) + " " + BinaryExpression.this.token.getText() + " " + String.valueOf(BinaryExpression.this.right);
            }
        };
    }

    private Expression createRegexExpression(final CamelContext camelContext, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Predicate predicate = PredicateBuilder.regex(leftExp, rightExp.evaluate(exchange, String.class));
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_REGEX) {
                    predicate = PredicateBuilder.not(predicate);
                }
                boolean answer = predicate.matches(exchange);
                return camelContext.getTypeConverter().convertTo(type, answer);
            }

            public String toString() {
                return String.valueOf(BinaryExpression.this.left) + " " + BinaryExpression.this.token.getText() + " " + String.valueOf(BinaryExpression.this.right);
            }
        };
    }

    private Expression createInExpression(final CamelContext camelContext, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Iterator<?> it = org.apache.camel.support.ObjectHelper.createIterator(rightExp.evaluate(exchange, Object.class));
                ArrayList values = new ArrayList();
                while (it.hasNext()) {
                    values.add(it.next());
                }
                ValueBuilder vb = new ValueBuilder(leftExp);
                Predicate predicate = vb.in(values.toArray());
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_IN) {
                    predicate = PredicateBuilder.not(predicate);
                }
                boolean answer = predicate.matches(exchange);
                return camelContext.getTypeConverter().convertTo(type, answer);
            }

            public String toString() {
                return String.valueOf(BinaryExpression.this.left) + " " + BinaryExpression.this.token.getText() + " " + String.valueOf(BinaryExpression.this.right);
            }
        };
    }

    private Expression createRangeExpression(final CamelContext camelContext, final String expression, final Expression leftExp, final Expression rightExp) {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String range = rightExp.evaluate(exchange, String.class);
                Matcher matcher = RANGE_PATTERN.matcher(range);
                if (!matcher.matches()) {
                    throw new SimpleIllegalSyntaxException(expression, BinaryExpression.this.right.getToken().getIndex(), String.valueOf((Object)BinaryExpression.this.operator) + " operator is not valid. Valid syntax:'from..to' (where from and to are numbers).");
                }
                Expression from = ExpressionBuilder.constantExpression(matcher.group(1));
                Expression to = ExpressionBuilder.constantExpression(matcher.group(3));
                Predicate predicate = PredicateBuilder.isGreaterThanOrEqualTo(leftExp, from);
                predicate = PredicateBuilder.and(predicate, PredicateBuilder.isLessThanOrEqualTo(leftExp, to));
                if (BinaryExpression.this.operator == BinaryOperatorType.NOT_RANGE) {
                    predicate = PredicateBuilder.not(predicate);
                }
                boolean answer = predicate.matches(exchange);
                return camelContext.getTypeConverter().convertTo(type, answer);
            }

            public String toString() {
                return String.valueOf(BinaryExpression.this.left) + " " + BinaryExpression.this.token.getText() + " " + String.valueOf(BinaryExpression.this.right);
            }
        };
    }

    private Expression createExpression(final CamelContext camelContext, final Expression left, final Expression right, final Predicate predicate) {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                boolean answer = predicate.matches(exchange);
                return camelContext.getTypeConverter().convertTo(type, answer);
            }

            public String toString() {
                return String.valueOf(left) + " " + BinaryExpression.this.token.getText() + " " + String.valueOf(right);
            }
        };
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        ObjectHelper.notNull(this.left, "left node", this);
        ObjectHelper.notNull(this.right, "right node", this);
        String leftExp = this.left.createCode(expression);
        String rightExp = this.right.createCode(expression);
        if (this.operator == BinaryOperatorType.EQ) {
            return "isEqualTo(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.EQ_IGNORE) {
            return "isEqualToIgnoreCase(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.GT) {
            return "isGreaterThan(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.GTE) {
            return "isGreaterThanOrEqualTo(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.LT) {
            return "isLessThan(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.LTE) {
            return "isLessThanOrEqualTo(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_EQ) {
            return "isNotEqualTo(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_EQ_IGNORE) {
            return "!isEqualToIgnoreCase(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.CONTAINS) {
            return "contains(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.CONTAINS_IGNORECASE) {
            return "containsIgnoreCase(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS) {
            return "!contains(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_CONTAINS_IGNORECASE) {
            return "!containsIgnoreCase(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.IS) {
            Object type = StringHelper.removeQuotes(rightExp);
            if (!((String)type).endsWith(".class")) {
                type = (String)type + ".class";
            }
            type = ((String)type).replace('$', '.');
            type = ((String)type).trim();
            return "is(exchange, " + leftExp + ", " + (String)type + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_IS) {
            Object type = StringHelper.removeQuotes(rightExp);
            if (!((String)type).endsWith(".class")) {
                type = (String)type + ".class";
            }
            type = ((String)type).replace('$', '.');
            type = ((String)type).trim();
            return "!is(exchange, " + leftExp + ", " + (String)type + ")";
        }
        if (this.operator == BinaryOperatorType.REGEX) {
            String escaped = rightExp.replace("\\", "\\\\");
            return "regexp(exchange, " + leftExp + ", " + escaped + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_REGEX) {
            String escaped = rightExp.replace("\\", "\\\\");
            return "!regexp(exchange, " + leftExp + ", " + escaped + ")";
        }
        if (this.operator == BinaryOperatorType.IN) {
            return "in(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_IN) {
            return "!in(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.RANGE) {
            return "range(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.NOT_RANGE) {
            return "!range(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.STARTS_WITH) {
            return "startsWith(exchange, " + leftExp + ", " + rightExp + ")";
        }
        if (this.operator == BinaryOperatorType.ENDS_WITH) {
            return "endsWith(exchange, " + leftExp + ", " + rightExp + ")";
        }
        throw new SimpleParserException("Unknown binary operator " + String.valueOf((Object)this.operator), this.token.getIndex());
    }
}

