/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.tokenizer;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.IteratorConvertTo;
import org.apache.camel.support.SingleInputTypedLanguageSupport;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="tokenize")
public class TokenizeLanguage
extends SingleInputTypedLanguageSupport {
    @Override
    protected boolean supportResultType() {
        return false;
    }

    @Override
    public Expression createExpression(Expression source, String expression, Object[] properties) {
        final Class type = this.property(Class.class, properties, 0, null);
        String token = this.property(String.class, properties, 2, expression);
        String endToken = this.property(String.class, properties, 3, null);
        String inheritNamespaceTagName = this.property(String.class, properties, 4, null);
        String groupDelimiter = this.property(String.class, properties, 5, null);
        boolean regex = this.property(Boolean.TYPE, properties, 6, false);
        boolean xml = this.property(Boolean.TYPE, properties, 7, false);
        boolean includeTokens = this.property(Boolean.TYPE, properties, 8, false);
        String group = this.property(String.class, properties, 9, null);
        boolean skipFirst = this.property(Boolean.TYPE, properties, 10, false);
        if (endToken != null && inheritNamespaceTagName != null) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (xml && (endToken != null || includeTokens)) {
            throw new IllegalArgumentException("Cannot have both xml and pair tokenizer enabled.");
        }
        if (endToken == null && includeTokens) {
            throw new IllegalArgumentException("The option includeTokens requires endToken to be specified.");
        }
        Expression answer = null;
        if (xml) {
            answer = ExpressionBuilder.tokenizeXMLExpression(source, token, inheritNamespaceTagName);
        } else if (endToken != null) {
            answer = ExpressionBuilder.tokenizePairExpression(token, endToken, includeTokens);
        }
        if (answer == null) {
            answer = regex ? ExpressionBuilder.regexTokenizeExpression(source, token) : ExpressionBuilder.tokenizeExpression(source, token);
            if (group == null && skipFirst) {
                answer = ExpressionBuilder.skipFirstExpression(answer);
            }
        }
        if (group != null) {
            if (xml) {
                answer = ExpressionBuilder.groupXmlIteratorExpression(answer, group);
            } else {
                String delim = groupDelimiter != null ? groupDelimiter : token;
                answer = ExpressionBuilder.groupIteratorExpression(answer, delim, group, skipFirst);
            }
        }
        if (type != null && type != Object.class) {
            final Expression delegate = answer;
            answer = new ExpressionAdapter(){

                @Override
                public Object evaluate(Exchange exchange) {
                    Object value = delegate.evaluate(exchange, Object.class);
                    if (value instanceof Iterator) {
                        Iterator it = (Iterator)value;
                        value = new IteratorConvertTo(exchange, it, type);
                    }
                    return value;
                }

                @Override
                public void init(CamelContext context) {
                    super.init(context);
                    delegate.init(context);
                }

                public String toString() {
                    return delegate.toString();
                }
            };
        }
        if (this.getCamelContext() != null) {
            answer.init(this.getCamelContext());
        }
        return answer;
    }
}

