/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.CamelConfiguration;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Configuration;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.NonManagedService;
import org.apache.camel.PropertiesLookupListener;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.StartupStep;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.DebuggerJmxConnectorService;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.impl.engine.DefaultCompileStrategy;
import org.apache.camel.impl.engine.DefaultRoutesLoader;
import org.apache.camel.main.DebuggerConfigurationProperties;
import org.apache.camel.main.DefaultConfigurationConfigurer;
import org.apache.camel.main.DefaultRoutesCollector;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.HttpServerConfigurationProperties;
import org.apache.camel.main.MainAutowiredLifecycleStrategy;
import org.apache.camel.main.MainConfigurationProperties;
import org.apache.camel.main.MainConstants;
import org.apache.camel.main.MainHelper;
import org.apache.camel.main.MainHttpServerFactory;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainPropertiesReload;
import org.apache.camel.main.MainSupportModelConfigurer;
import org.apache.camel.main.ProfileConfigurer;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.main.PropertyOptionKey;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.RouteControllerConfigurationProperties;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.main.SSLConfigurationProperties;
import org.apache.camel.main.TracerConfigurationProperties;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BacklogTracer;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.CamelMetricsService;
import org.apache.camel.spi.CamelTracingService;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DebuggerFactory;
import org.apache.camel.spi.HasId;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.SimpleEventNotifierSupport;
import org.apache.camel.support.jsse.KeyManagersParameters;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.jsse.SSLContextServerParameters;
import org.apache.camel.support.jsse.TrustManagersParameters;
import org.apache.camel.support.scan.PackageScanHelper;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.startup.BacklogStartupStepRecorder;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.LocationHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.SensitiveUtils;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMainSupport
extends BaseService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMainSupport.class);
    protected final List<MainListener> listeners = new ArrayList<MainListener>();
    protected volatile CamelContext camelContext;
    protected final MainConfigurationProperties mainConfigurationProperties = new MainConfigurationProperties();
    protected final OrderedLocationProperties wildcardProperties = new OrderedLocationProperties();
    protected RoutesCollector routesCollector = new DefaultRoutesCollector();
    protected String propertyPlaceholderLocations;
    protected String defaultPropertyPlaceholderLocation = "classpath:application.properties;optional=true";
    protected Properties initialProperties;
    protected Properties overrideProperties;
    protected boolean standalone = true;
    protected final MainHelper helper;

    protected BaseMainSupport() {
        this.helper = new MainHelper();
    }

    protected BaseMainSupport(CamelContext camelContext) {
        this.camelContext = camelContext;
        this.helper = new MainHelper();
    }

    public MainConfigurationProperties configure() {
        return this.mainConfigurationProperties;
    }

    public RoutesCollector getRoutesCollector() {
        return this.routesCollector;
    }

    public void setRoutesCollector(RoutesCollector routesCollector) {
        this.routesCollector = routesCollector;
    }

    public String getPropertyPlaceholderLocations() {
        return this.propertyPlaceholderLocations;
    }

    public void setPropertyPlaceholderLocations(String location) {
        this.propertyPlaceholderLocations = location;
    }

    public String getDefaultPropertyPlaceholderLocation() {
        return this.defaultPropertyPlaceholderLocation;
    }

    public void setDefaultPropertyPlaceholderLocation(String defaultPropertyPlaceholderLocation) {
        this.defaultPropertyPlaceholderLocation = defaultPropertyPlaceholderLocation;
    }

    public Properties getInitialProperties() {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        return this.initialProperties;
    }

    public void setInitialProperties(Properties initialProperties) {
        this.initialProperties = initialProperties;
    }

    public void setInitialProperties(Map<String, Object> initialProperties) {
        this.initialProperties = new OrderedProperties();
        this.initialProperties.putAll(initialProperties);
    }

    public void addProperty(String key, String value) {
        this.addInitialProperty(key, value);
    }

    public void addInitialProperty(String key, String value) {
        if (this.initialProperties == null) {
            this.initialProperties = new OrderedProperties();
        }
        this.initialProperties.setProperty(key, value);
    }

    public Properties getOverrideProperties() {
        return this.overrideProperties;
    }

    public void setOverrideProperties(Properties overrideProperties) {
        this.overrideProperties = overrideProperties;
    }

    public void setOverrideProperties(Map<String, Object> initialProperties) {
        this.overrideProperties = new OrderedProperties();
        this.overrideProperties.putAll(initialProperties);
    }

    public void addOverrideProperty(String key, String value) {
        if (this.overrideProperties == null) {
            this.overrideProperties = new OrderedProperties();
        }
        this.overrideProperties.setProperty(key, value);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void addMainListener(MainListener listener) {
        this.listeners.add(listener);
    }

    public void removeMainListener(MainListener listener) {
        this.listeners.remove(listener);
    }

    protected void loadCustomBeans(CamelContext camelContext) throws Exception {
        String basePackage = camelContext.getCamelContextExtension().getBasePackageScan();
        if (basePackage != null) {
            PackageScanHelper.registerBeans(camelContext, Set.of(basePackage));
        }
    }

    protected void loadConfigurations(CamelContext camelContext) throws Exception {
        String basePackage = camelContext.getCamelContextExtension().getBasePackageScan();
        if (basePackage != null) {
            PackageScanClassResolver pscr = PluginHelper.getPackageScanClassResolver(camelContext);
            Set<Class<?>> set = pscr.findImplementations(CamelConfiguration.class, basePackage);
            Set<Class<?>> found2 = pscr.findAnnotated(Configuration.class, basePackage);
            LinkedHashSet found = new LinkedHashSet();
            found.addAll(set);
            found.addAll(found2);
            for (Class clazz : found) {
                Object config = camelContext.getInjector().newInstance(clazz);
                if (!(config instanceof CamelConfiguration)) continue;
                CamelConfiguration cc = (CamelConfiguration)config;
                LOG.debug("Discovered CamelConfiguration class: {}", (Object)cc);
                this.mainConfigurationProperties.addConfiguration(cc);
            }
        }
        if (this.mainConfigurationProperties.getConfigurationClasses() != null) {
            String[] configClasses;
            for (String configClass : configClasses = this.mainConfigurationProperties.getConfigurationClasses().split(",")) {
                Class<CamelConfiguration> clazz = camelContext.getClassResolver().resolveClass(configClass, CamelConfiguration.class);
                boolean mainClass = false;
                try {
                    clazz.getDeclaredMethod("main", String[].class);
                    mainClass = true;
                }
                catch (NoSuchMethodException cc) {
                    // empty catch block
                }
                if (mainClass) continue;
                CamelConfiguration config = camelContext.getInjector().newInstance(clazz);
                this.mainConfigurationProperties.addConfiguration(config);
            }
        }
        CamelBeanPostProcessor postProcessor = PluginHelper.getBeanPostProcessor(camelContext);
        Set<CamelConfiguration> set = camelContext.getRegistry().findByType(CamelConfiguration.class);
        for (CamelConfiguration configuration : set) {
            postProcessor.postProcessBeforeInitialization(configuration, configuration.getClass().getName());
            postProcessor.postProcessAfterInitialization(configuration, configuration.getClass().getName());
        }
        for (CamelConfiguration configuration : this.mainConfigurationProperties.getConfigurations()) {
            postProcessor.postProcessBeforeInitialization(configuration, configuration.getClass().getName());
            postProcessor.postProcessAfterInitialization(configuration, configuration.getClass().getName());
        }
        for (CamelConfiguration config : this.mainConfigurationProperties.getConfigurations()) {
            config.configure(camelContext);
        }
        for (CamelConfiguration config : set) {
            config.configure(camelContext);
        }
    }

    protected void configurePropertiesService(CamelContext camelContext) throws Exception {
        Properties op;
        Properties ip;
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        if (pc.getLocations().isEmpty()) {
            String locations = this.propertyPlaceholderLocations;
            if (locations == null) {
                String profile = MainHelper.lookupPropertyFromSysOrEnv("camel.main.profile").orElse(this.mainConfigurationProperties.getProfile());
                if (profile == null) {
                    Properties prop = new Properties();
                    try (InputStream is = ResourceHelper.resolveResourceAsInputStream(camelContext, "application.properties");){
                        if (is != null) {
                            prop.load(is);
                        }
                    }
                    profile = prop.getProperty("camel.main.profile");
                }
                if (profile != null) {
                    this.mainConfigurationProperties.setProfile(profile);
                    String loc = MainConstants.profilePropertyPlaceholderLocation(profile);
                    if (!this.defaultPropertyPlaceholderLocation.contains(loc)) {
                        this.defaultPropertyPlaceholderLocation = loc + "," + this.defaultPropertyPlaceholderLocation;
                    }
                }
                locations = MainHelper.lookupPropertyFromSysOrEnv("camel.main.property-placeholder-location").orElse(this.defaultPropertyPlaceholderLocation);
            }
            if (locations != null) {
                locations = locations.trim();
            }
            if (!Objects.equals(locations, "false")) {
                pc.addLocation(locations);
                if (this.defaultPropertyPlaceholderLocation.equals(locations)) {
                    LOG.debug("Properties location: {}", (Object)locations);
                } else {
                    LOG.info("Properties location: {}", (Object)locations);
                }
            }
        }
        if ((ip = this.tryLoadProperties(this.initialProperties, "camel.main.initial-properties-location", camelContext)) != null) {
            pc.setInitialProperties(ip);
        }
        if ((op = this.tryLoadProperties(this.overrideProperties, "camel.main.override-properties-location", camelContext)) != null) {
            pc.setOverrideProperties(op);
        }
    }

    private Properties tryLoadProperties(Properties initialProperties, String initialPropertiesLocation, CamelContext camelContext) throws IOException {
        Optional<String> location;
        Properties ip = initialProperties;
        if ((ip == null || ip.isEmpty()) && (location = MainHelper.lookupPropertyFromSysOrEnv(initialPropertiesLocation)).isPresent()) {
            try (InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, location.get());){
                ip = new Properties();
                ip.load(is);
            }
        }
        return ip;
    }

    protected void configureLifecycle(CamelContext camelContext) throws Exception {
    }

    private void scheduleRefresh(CamelContext camelContext, String key, long period) throws Exception {
        Optional<Runnable> task = PluginHelper.getPeriodTaskResolver(camelContext).newInstance(key, Runnable.class);
        if (task.isPresent()) {
            Runnable r = task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration(period, false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                DefaultContextReloadStrategy reloader = new DefaultContextReloadStrategy();
                camelContext.addService(reloader);
            }
            PeriodTaskScheduler scheduler = PluginHelper.getPeriodTaskScheduler(camelContext);
            scheduler.schedulePeriodTask(r, period);
        }
    }

    protected void autoconfigure(CamelContext camelContext) throws Exception {
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        ProfileConfigurer.configureMain(camelContext, this.mainConfigurationProperties.getProfile(), this.mainConfigurationProperties);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFailFast(camelContext, autoConfiguredProperties);
            this.autoConfigurationPropertiesComponent(camelContext, autoConfiguredProperties);
            this.autoConfigurationSingleOption(camelContext, autoConfiguredProperties, "camel.main.routesIncludePattern", value -> {
                this.mainConfigurationProperties.setRoutesIncludePattern((String)value);
                return null;
            });
            if (this.mainConfigurationProperties.isModeline()) {
                camelContext.setModeline(true);
            }
            this.modelineRoutes(camelContext);
            this.autoConfigurationMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        }
        this.doConfigureCamelContextFromMainConfiguration(camelContext, this.mainConfigurationProperties, autoConfiguredProperties);
        this.configurePackageScan(camelContext);
        this.loadCustomBeans(camelContext);
        this.loadConfigurations(camelContext);
        if (this.mainConfigurationProperties.isAutoConfigurationEnabled()) {
            this.autoConfigurationFromProperties(camelContext, autoConfiguredProperties);
            this.autowireWildcardProperties(camelContext);
            camelContext.addService(new MainPropertiesReload(this));
        }
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            BaseMainSupport.logConfigurationSummary(autoConfiguredProperties);
        }
        this.helper.bootstrapDone();
    }

    private static void logConfigurationSummary(OrderedLocationProperties autoConfiguredProperties) {
        MainHelper.logConfigurationSummary(LOG, autoConfiguredProperties, "Variables summary", k -> k.startsWith("camel.variable."));
        MainHelper.logConfigurationSummary(LOG, autoConfiguredProperties, "Auto-configuration summary", null);
    }

    protected void configureStartupRecorder(CamelContext camelContext) {
        StartupStepRecorder fr;
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        Properties prop = camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        Object value = prop.remove("camel.main.startupRecorder");
        if (ObjectHelper.isNotEmpty(value)) {
            this.mainConfigurationProperties.setStartupRecorder(value.toString());
        }
        if (ObjectHelper.isNotEmpty(value = prop.remove("camel.main.startupRecorderRecording"))) {
            this.mainConfigurationProperties.setStartupRecorderRecording("true".equalsIgnoreCase(value.toString()));
        }
        if (ObjectHelper.isNotEmpty(value = prop.remove("camel.main.startupRecorderProfile"))) {
            this.mainConfigurationProperties.setStartupRecorderProfile(CamelContextHelper.parseText(camelContext, value.toString()));
        }
        if (ObjectHelper.isNotEmpty(value = prop.remove("camel.main.startupRecorderDuration"))) {
            this.mainConfigurationProperties.setStartupRecorderDuration(Long.parseLong(value.toString()));
        }
        if (ObjectHelper.isNotEmpty(value = prop.remove("camel.main.startupRecorderMaxDepth"))) {
            this.mainConfigurationProperties.setStartupRecorderMaxDepth(Integer.parseInt(value.toString()));
        }
        if ("off".equals(this.mainConfigurationProperties.getStartupRecorder()) || "false".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            ecc.getStartupStepRecorder().setEnabled(false);
        } else if ("logging".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                ecc.setStartupStepRecorder(new LoggingStartupStepRecorder());
            }
        } else if ("backlog".equals(this.mainConfigurationProperties.getStartupRecorder())) {
            if (!(ecc.getStartupStepRecorder() instanceof BacklogStartupStepRecorder)) {
                ecc.setStartupStepRecorder(new BacklogStartupStepRecorder());
            }
        } else if (("jfr".equals(this.mainConfigurationProperties.getStartupRecorder()) || "java-flight-recorder".equals(this.mainConfigurationProperties.getStartupRecorder()) || this.mainConfigurationProperties.getStartupRecorder() == null) && (fr = (StartupStepRecorder)ecc.getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            fr.setRecording(this.mainConfigurationProperties.isStartupRecorderRecording());
            fr.setStartupRecorderDuration(this.mainConfigurationProperties.getStartupRecorderDuration());
            fr.setRecordingProfile(this.mainConfigurationProperties.getStartupRecorderProfile());
            fr.setMaxDepth(this.mainConfigurationProperties.getStartupRecorderMaxDepth());
            camelContext.getCamelContextExtension().setStartupStepRecorder(fr);
        }
    }

    protected void configurePackageScan(CamelContext camelContext) {
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            String base = this.mainConfigurationProperties.getBasePackageScan();
            String current = camelContext.getCamelContextExtension().getBasePackageScan();
            if (base != null && !base.equals(current)) {
                camelContext.getCamelContextExtension().setBasePackageScan(base);
                LOG.info("Classpath scanning enabled from base package: {}", (Object)base);
            }
        }
    }

    protected void configureRoutesLoader(CamelContext camelContext) {
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        if (this.mainConfigurationProperties.getCompileWorkDir() != null) {
            CompileStrategy cs = camelContext.getCamelContextExtension().getContextPlugin(CompileStrategy.class);
            if (cs == null) {
                cs = new DefaultCompileStrategy();
                ecc.addContextPlugin(CompileStrategy.class, cs);
            }
            cs.setWorkDir(this.mainConfigurationProperties.getCompileWorkDir());
        }
        DefaultRoutesLoader loader = new DefaultRoutesLoader();
        loader.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        ecc.addContextPlugin(RoutesLoader.class, loader);
    }

    protected void modelineRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = this.doCommonRouteConfiguration(camelContext);
        configurer.configureModeline(camelContext);
    }

    protected void configureRoutes(CamelContext camelContext) throws Exception {
        RoutesConfigurer configurer = this.doCommonRouteConfiguration(camelContext);
        configurer.configureRoutes(camelContext);
    }

    private RoutesConfigurer doCommonRouteConfiguration(CamelContext camelContext) {
        RoutesConfigurer configurer = new RoutesConfigurer();
        this.routesCollector.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        if (this.mainConfigurationProperties.isRoutesCollectorEnabled()) {
            configurer.setRoutesCollector(this.routesCollector);
            configurer.setIgnoreLoadingError(this.mainConfigurationProperties.isRoutesCollectorIgnoreLoadingError());
        }
        configurer.setBeanPostProcessor(PluginHelper.getBeanPostProcessor(camelContext));
        configurer.setRoutesBuilders(this.mainConfigurationProperties.getRoutesBuilders());
        configurer.setRoutesBuilderClasses(this.mainConfigurationProperties.getRoutesBuilderClasses());
        if (this.mainConfigurationProperties.isBasePackageScanEnabled()) {
            configurer.setBasePackageScan(this.mainConfigurationProperties.getBasePackageScan());
        }
        configurer.setJavaRoutesExcludePattern(this.mainConfigurationProperties.getJavaRoutesExcludePattern());
        configurer.setJavaRoutesIncludePattern(this.mainConfigurationProperties.getJavaRoutesIncludePattern());
        configurer.setRoutesExcludePattern(this.mainConfigurationProperties.getRoutesExcludePattern());
        configurer.setRoutesIncludePattern(this.mainConfigurationProperties.getRoutesIncludePattern());
        return configurer;
    }

    protected LifecycleStrategy createLifecycleStrategy(CamelContext camelContext) {
        return new MainAutowiredLifecycleStrategy(camelContext);
    }

    protected void postProcessCamelContext(CamelContext camelContext) throws Exception {
        StartupStep step;
        OrderedLocationProperties propertyPlaceholders = new OrderedLocationProperties();
        camelContext.getLifecycleStrategies().removeIf(s -> s instanceof AutowiredLifecycleStrategy);
        camelContext.addLifecycleStrategy(this.createLifecycleStrategy(camelContext));
        this.configurePropertiesService(camelContext);
        PropertiesComponent pc = camelContext.getPropertiesComponent();
        pc.addPropertiesLookupListener(new PropertyPlaceholderListener(propertyPlaceholders));
        this.configureStartupRecorder(camelContext);
        this.configurePackageScan(camelContext);
        this.configureRoutesLoader(camelContext);
        camelContext.build();
        for (MainListener listener : this.listeners) {
            listener.beforeInitialize(this);
        }
        for (MainListener listener : this.listeners) {
            listener.beforeConfigure(this);
        }
        StartupStepRecorder recorder = camelContext.getCamelContextExtension().getStartupStepRecorder();
        if (this.standalone) {
            step = recorder.beginStep(BaseMainSupport.class, "autoconfigure", "Auto Configure");
            this.autoconfigure(camelContext);
            recorder.endStep(step);
        }
        this.configureLifecycle(camelContext);
        if (this.standalone) {
            this.detectCamelDebugJar(camelContext);
            step = recorder.beginStep(BaseMainSupport.class, "configureRoutes", "Collect Routes");
            this.configureRoutes(camelContext);
            recorder.endStep(step);
        }
        this.postProcessCamelRegistry(camelContext, this.mainConfigurationProperties);
        for (MainListener listener : this.listeners) {
            listener.afterConfigure(this);
        }
        if (this.standalone && this.mainConfigurationProperties.isAutoConfigurationLogSummary()) {
            camelContext.getManagementStrategy().addEventNotifier(new PlaceholderSummaryEventNotifier(propertyPlaceholders));
        }
    }

    protected void detectCamelDebugJar(CamelContext camelContext) {
        DebuggerFactory df = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("debugger-factory", DebuggerFactory.class).orElse(null);
        if (df != null) {
            camelContext.setSourceLocationEnabled(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationFailFast(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Object val;
        Object failFast;
        Object jvmEnabled;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (String key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", (Object)key, (Object)prop.getProperty(key));
        }
        Object envEnabled = prop.remove("camel.main.autoConfigurationEnvironmentVariablesEnabled");
        if (ObjectHelper.isNotEmpty(envEnabled)) {
            this.mainConfigurationProperties.setAutoConfigurationEnvironmentVariablesEnabled(CamelContextHelper.parseBoolean(camelContext, envEnabled.toString()));
            String loc = prop.getLocation("camel.main.autoConfigurationEnvironmentVariablesEnabled");
            autoConfiguredProperties.put(loc, "camel.main.autoConfigurationEnvironmentVariablesEnabled", envEnabled.toString());
        }
        if (ObjectHelper.isNotEmpty(jvmEnabled = prop.remove("camel.main.autoConfigurationSystemPropertiesEnabled"))) {
            this.mainConfigurationProperties.setAutoConfigurationSystemPropertiesEnabled(CamelContextHelper.parseBoolean(camelContext, jvmEnabled.toString()));
            String loc = prop.getLocation("camel.main.autoConfigurationSystemPropertiesEnabled");
            autoConfiguredProperties.put(loc, "camel.autoConfigurationSystemPropertiesEnabled", jvmEnabled.toString());
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll((Map)propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = failFast = propENV != null ? propENV.remove("camel.main.autoconfigurationfailfast") : null;
        if (ObjectHelper.isNotEmpty(propJVM) && ObjectHelper.isNotEmpty(val = propJVM.remove("camel.main.autoconfigurationfailfast"))) {
            String string2 = "SYS";
            failFast = val;
        }
        if (ObjectHelper.isNotEmpty(failFast)) {
            void var8_13;
            this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean(camelContext, failFast.toString()));
            autoConfiguredProperties.put((String)var8_13, "camel.main.autoConfigurationFailFast", failFast.toString());
        } else {
            String string3 = prop.getLocation("camel.main.autoConfigurationFailFast");
            failFast = prop.remove("camel.main.autoConfigurationFailFast");
            if (ObjectHelper.isNotEmpty(failFast)) {
                this.mainConfigurationProperties.setAutoConfigurationFailFast(CamelContextHelper.parseBoolean(camelContext, failFast.toString()));
                autoConfiguredProperties.put(string3, "camel.main.autoConfigurationFailFast", failFast.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void autoConfigurationSingleOption(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties, String optionName, Function<String, Object> setter) {
        Object val;
        Object value;
        String lowerOptionName = optionName.toLowerCase(Locale.US);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        LOG.debug("Properties from Camel properties component:");
        for (Object key : prop.stringPropertyNames()) {
            LOG.debug("    {}={}", key, (Object)prop.getProperty((String)key));
        }
        Properties propENV = null;
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String string : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)string, (Object)propENV.getProperty(string));
            }
        }
        Properties propJVM = null;
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        String string = "ENV";
        Object object = value = propENV != null ? propENV.remove(lowerOptionName) : null;
        if (ObjectHelper.isNotEmpty(propJVM) && ObjectHelper.isNotEmpty(val = propJVM.remove(optionName))) {
            String string2 = "SYS";
            value = val;
        }
        if (ObjectHelper.isEmpty(value)) {
            String string3 = prop.getLocation(optionName);
            value = prop.remove(optionName);
        }
        if (ObjectHelper.isEmpty(value)) {
            value = this.getInitialProperties().getProperty(optionName);
            String string4 = "initial";
        }
        if (ObjectHelper.isNotEmpty(value)) {
            void var9_18;
            String str = CamelContextHelper.parseText(camelContext, value.toString());
            setter.apply(str);
            autoConfiguredProperties.put((String)var9_18, optionName, value.toString());
        }
    }

    protected void doConfigureCamelContextFromMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean hc;
        Properties propJVM;
        Properties propENV;
        if (ObjectHelper.isNotEmpty(config.getFileConfigurations())) {
            String[] locs;
            for (String loc : locs = config.getFileConfigurations().split(",")) {
                String pattern;
                File[] files;
                String path = FileUtil.onlyPath(loc);
                if (path == null || (files = new File(path).listFiles(arg_0 -> BaseMainSupport.lambda$doConfigureCamelContextFromMainConfiguration$6(pattern = loc.length() > path.length() ? loc.substring(path.length() + 1) : null, arg_0))) == null) continue;
                for (File file : files) {
                    Properties props = new Properties();
                    try (FileInputStream is = new FileInputStream(file);){
                        props.load(is);
                    }
                    if (props.isEmpty()) continue;
                    if (this.overrideProperties == null) {
                        this.overrideProperties = new Properties();
                        PropertiesComponent pc = camelContext.getPropertiesComponent();
                        pc.setOverrideProperties(this.overrideProperties);
                    }
                    LOG.info("Loaded additional {} properties from file: {}", (Object)props.size(), (Object)file);
                    this.overrideProperties.putAll((Map<?, ?>)props);
                }
            }
        }
        DefaultConfigurationConfigurer.configure(camelContext, config);
        this.preProcessCamelRegistry(camelContext, config);
        DefaultConfigurationConfigurer.afterConfigure(camelContext);
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("ENV", propENV);
            LOG.debug("Properties from OS environment variables:");
            for (String key : propENV.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propENV.getProperty(key));
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
            LOG.debug("Properties from JVM system properties:");
            for (String key : propJVM.stringPropertyNames()) {
                LOG.debug("    {}={}", (Object)key, (Object)propJVM.getProperty(key));
            }
        }
        OrderedLocationProperties contextProperties = new OrderedLocationProperties();
        OrderedLocationProperties resilience4jProperties = new OrderedLocationProperties();
        OrderedLocationProperties faultToleranceProperties = new OrderedLocationProperties();
        OrderedLocationProperties restProperties = new OrderedLocationProperties();
        OrderedLocationProperties vaultProperties = new OrderedLocationProperties();
        OrderedLocationProperties threadPoolProperties = new OrderedLocationProperties();
        OrderedLocationProperties healthProperties = new OrderedLocationProperties();
        OrderedLocationProperties lraProperties = new OrderedLocationProperties();
        OrderedLocationProperties otelProperties = new OrderedLocationProperties();
        OrderedLocationProperties metricsProperties = new OrderedLocationProperties();
        OrderedLocationProperties routeTemplateProperties = new OrderedLocationProperties();
        OrderedLocationProperties variableProperties = new OrderedLocationProperties();
        OrderedLocationProperties beansProperties = new OrderedLocationProperties();
        OrderedLocationProperties devConsoleProperties = new OrderedLocationProperties();
        OrderedLocationProperties globalOptions = new OrderedLocationProperties();
        OrderedLocationProperties httpServerProperties = new OrderedLocationProperties();
        OrderedLocationProperties sslProperties = new OrderedLocationProperties();
        OrderedLocationProperties debuggerProperties = new OrderedLocationProperties();
        OrderedLocationProperties tracerProperties = new OrderedLocationProperties();
        OrderedLocationProperties routeControllerProperties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            String option;
            String value;
            String loc = prop.getLocation(key);
            if (StringHelper.startsWithIgnoreCase(key, "camel.context.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                contextProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.resilience4j.")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                resilience4jProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.faulttolerance.")) {
                value = prop.getProperty(key);
                option = key.substring(21);
                MainHelper.validateOptionAndValue(key, option, value);
                faultToleranceProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.rest.")) {
                value = prop.getProperty(key);
                option = key.substring(11);
                MainHelper.validateOptionAndValue(key, option, value);
                restProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.vault.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                vaultProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.threadpool.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                threadPoolProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.health.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                healthProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.lra.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                lraProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.opentelemetry.")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                MainHelper.validateOptionAndValue(key, option, value);
                otelProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.metrics.")) {
                value = prop.getProperty(key);
                option = key.substring(14);
                MainHelper.validateOptionAndValue(key, option, value);
                metricsProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.routeTemplate")) {
                value = prop.getProperty(key);
                option = key.substring(19);
                MainHelper.validateOptionAndValue(key, option, value);
                routeTemplateProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.devConsole.")) {
                value = prop.getProperty(key);
                option = key.substring(17);
                MainHelper.validateOptionAndValue(key, option, value);
                devConsoleProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.variable.")) {
                value = prop.getProperty(key);
                option = key.substring(15);
                MainHelper.validateOptionAndValue(key, option, value);
                variableProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.beans.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                beansProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.globalOptions.")) {
                value = prop.getProperty(key);
                option = key.substring(20);
                MainHelper.validateOptionAndValue(key, option, value);
                globalOptions.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.server.")) {
                value = prop.getProperty(key);
                option = key.substring(13);
                MainHelper.validateOptionAndValue(key, option, value);
                httpServerProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.ssl.")) {
                value = prop.getProperty(key);
                option = key.substring(10);
                MainHelper.validateOptionAndValue(key, option, value);
                sslProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.debug.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                debuggerProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (StringHelper.startsWithIgnoreCase(key, "camel.trace.")) {
                value = prop.getProperty(key);
                option = key.substring(12);
                MainHelper.validateOptionAndValue(key, option, value);
                tracerProperties.put(loc, MainHelper.optionKey(option), value);
                continue;
            }
            if (!StringHelper.startsWithIgnoreCase(key, "camel.routeController.")) continue;
            value = prop.getProperty(key);
            option = key.substring(22);
            MainHelper.validateOptionAndValue(key, option, value);
            routeControllerProperties.put(loc, MainHelper.optionKey(option), value);
        }
        if (!globalOptions.isEmpty()) {
            for (String name2 : globalOptions.stringPropertyNames()) {
                String value = globalOptions.getProperty(name2);
                this.mainConfigurationProperties.addGlobalOption(name2, value);
            }
        }
        if (!variableProperties.isEmpty()) {
            LOG.debug("Auto-configuring Variables from loaded properties: {}", (Object)variableProperties.size());
            MainSupportModelConfigurer.setVariableProperties(camelContext, variableProperties, autoConfiguredProperties);
        }
        if (!beansProperties.isEmpty()) {
            LOG.debug("Creating and binding beans to registry from loaded properties: {}", (Object)beansProperties.size());
            this.bindBeansToRegistry(camelContext, beansProperties, "camel.beans.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), this.mainConfigurationProperties.isAutoConfigurationLogSummary(), true, autoConfiguredProperties);
        }
        if (!contextProperties.isEmpty()) {
            LOG.debug("Auto-configuring CamelContext from loaded properties: {}", (Object)contextProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext, contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getCamelContextExtension(), contextProperties, "camel.context.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!restProperties.isEmpty() || this.mainConfigurationProperties.hasRestConfiguration()) {
            RestConfigurationProperties rest = this.mainConfigurationProperties.rest();
            LOG.debug("Auto-configuring Rest DSL from loaded properties: {}", (Object)restProperties.size());
            MainHelper.setPropertiesOnTarget(camelContext, rest, restProperties, "camel.rest.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            camelContext.setRestConfiguration(rest);
        }
        if (!httpServerProperties.isEmpty() || this.mainConfigurationProperties.hasHttpServerConfiguration()) {
            LOG.debug("Auto-configuring HTTP Server from loaded properties: {}", (Object)httpServerProperties.size());
            this.setHttpServerProperties(camelContext, httpServerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!vaultProperties.isEmpty() || this.mainConfigurationProperties.hasVaultConfiguration()) {
            LOG.debug("Auto-configuring Vault from loaded properties: {}", (Object)vaultProperties.size());
            this.setVaultProperties(camelContext, vaultProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!threadPoolProperties.isEmpty() || this.mainConfigurationProperties.hasThreadPoolConfiguration()) {
            LOG.debug("Auto-configuring Thread Pool from loaded properties: {}", (Object)threadPoolProperties.size());
            MainSupportModelConfigurer.setThreadPoolProperties(camelContext, this.mainConfigurationProperties, threadPoolProperties, autoConfiguredProperties);
        }
        boolean bl = hc = this.mainConfigurationProperties.health().getEnabled() != null;
        if (hc || !healthProperties.isEmpty() || this.mainConfigurationProperties.hasHealthCheckConfiguration()) {
            LOG.debug("Auto-configuring HealthCheck from loaded properties: {}", (Object)healthProperties.size());
            this.setHealthCheckProperties(camelContext, healthProperties, autoConfiguredProperties);
        }
        if (!routeTemplateProperties.isEmpty()) {
            LOG.debug("Auto-configuring Route templates from loaded properties: {}", (Object)routeTemplateProperties.size());
            this.setRouteTemplateProperties(camelContext, routeTemplateProperties, autoConfiguredProperties);
        }
        if (!lraProperties.isEmpty() || this.mainConfigurationProperties.hasLraConfiguration()) {
            LOG.debug("Auto-configuring Saga LRA from loaded properties: {}", (Object)lraProperties.size());
            this.setLraCheckProperties(camelContext, lraProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!otelProperties.isEmpty() || this.mainConfigurationProperties.hasOtelConfiguration()) {
            LOG.debug("Auto-configuring OpenTelemetry from loaded properties: {}", (Object)otelProperties.size());
            this.setOtelProperties(camelContext, otelProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!metricsProperties.isEmpty() || this.mainConfigurationProperties.hasMetricsConfiguration()) {
            LOG.debug("Auto-configuring Micrometer metrics from loaded properties: {}", (Object)metricsProperties.size());
            this.setMetricsProperties(camelContext, metricsProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!devConsoleProperties.isEmpty()) {
            LOG.debug("Auto-configuring Dev Console from loaded properties: {}", (Object)devConsoleProperties.size());
            this.setDevConsoleProperties(camelContext, devConsoleProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!sslProperties.isEmpty() || this.mainConfigurationProperties.hasSslConfiguration()) {
            LOG.debug("Auto-configuring SSL from loaded properties: {}", (Object)sslProperties.size());
            this.setSslProperties(camelContext, sslProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!debuggerProperties.isEmpty() || this.mainConfigurationProperties.hasDebuggerConfiguration()) {
            LOG.debug("Auto-configuring Debugger from loaded properties: {}", (Object)debuggerProperties.size());
            this.setDebuggerProperties(camelContext, debuggerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!tracerProperties.isEmpty() || this.mainConfigurationProperties.hasTracerConfiguration()) {
            LOG.debug("Auto-configuring Tracer from loaded properties: {}", (Object)tracerProperties.size());
            this.setTracerProperties(camelContext, tracerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        if (!routeControllerProperties.isEmpty() || this.mainConfigurationProperties.hasRouteControllerConfiguration()) {
            LOG.debug("Auto-configuring Route Controller from loaded properties: {}", (Object)routeControllerProperties.size());
            this.setRouteControllerProperties(camelContext, routeControllerProperties, this.mainConfigurationProperties.isAutoConfigurationFailFast(), autoConfiguredProperties);
        }
        MainSupportModelConfigurer.configureModelCamelContext(camelContext, this.mainConfigurationProperties, autoConfiguredProperties, resilience4jProperties, faultToleranceProperties);
        if (!variableProperties.isEmpty()) {
            variableProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.variable.{}={}", k, v)));
        }
        if (!beansProperties.isEmpty()) {
            beansProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.beans.{}={}", k, v)));
        }
        if (!contextProperties.isEmpty()) {
            contextProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.context.{}={}", k, v)));
        }
        if (!resilience4jProperties.isEmpty()) {
            resilience4jProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.resilience4j.{}={}", k, v)));
        }
        if (!faultToleranceProperties.isEmpty()) {
            faultToleranceProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.faulttolerance.{}={}", k, v)));
        }
        if (!restProperties.isEmpty()) {
            restProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.rest.{}={}", k, v)));
        }
        if (!vaultProperties.isEmpty()) {
            vaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.vault.{}={}", k, v)));
        }
        if (!threadPoolProperties.isEmpty()) {
            threadPoolProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.threadpool.{}={}", k, v)));
        }
        if (!healthProperties.isEmpty()) {
            healthProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.health.{}={}", k, v)));
        }
        if (!sslProperties.isEmpty()) {
            sslProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.ssl.{}={}", k, v)));
        }
        if (!debuggerProperties.isEmpty()) {
            debuggerProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.debug.{}={}", k, v)));
        }
        if (!routeControllerProperties.isEmpty()) {
            routeControllerProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.routeController.{}={}", k, v)));
        }
        if (!devConsoleProperties.isEmpty()) {
            devConsoleProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.devConsole.{}={}", k, v)));
        }
        if (!routeTemplateProperties.isEmpty()) {
            routeTemplateProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.routetemplate.{}={}", k, v)));
        }
        if (!lraProperties.isEmpty()) {
            lraProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.lra.{}={}", k, v)));
        }
        if (!otelProperties.isEmpty()) {
            otelProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.opentelemetry.{}={}", k, v)));
        }
        if (!httpServerProperties.isEmpty()) {
            httpServerProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.server.{}={}", k, v)));
        }
        DefaultConfigurationConfigurer.afterPropertiesSet(camelContext);
        DefaultConfigurationConfigurer.configureVault(camelContext);
    }

    protected void preProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
    }

    protected void postProcessCamelRegistry(CamelContext camelContext, MainConfigurationProperties config) {
    }

    private void setRouteTemplateProperties(CamelContext camelContext, OrderedLocationProperties routeTemplateProperties, OrderedLocationProperties autoConfiguredProperties) {
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        for (Map.Entry entry : routeTemplateProperties.entrySet()) {
            String key = entry.getKey().toString();
            String id = StringHelper.between(key, "[", "]");
            key = StringHelper.after(key, "].");
            source.addParameter(id, key, entry.getValue());
        }
        camelContext.getRegistry().bind("CamelMainRouteTemplateParametersSource", RouteTemplateParameterSource.class, source);
        TreeMap<String, Object> sorted = new TreeMap<String, Object>(routeTemplateProperties.asMap());
        sorted.forEach((k, v) -> {
            String loc = routeTemplateProperties.getLocation(k);
            autoConfiguredProperties.put(loc, "camel.routeTemplate" + k, v.toString());
        });
        routeTemplateProperties.clear();
    }

    private void setHealthCheckProperties(CamelContext camelContext, OrderedLocationProperties healthCheckProperties, OrderedLocationProperties autoConfiguredProperties) {
        HasId hc;
        HealthConfigurationProperties health = this.mainConfigurationProperties.health();
        MainHelper.setPropertiesOnTarget(camelContext, health, healthCheckProperties, "camel.health.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (health.getEnabled() != null && !health.getEnabled().booleanValue()) {
            return;
        }
        HealthCheckRegistry hcr = camelContext.getCamelContextExtension().getContextPlugin(HealthCheckRegistry.class);
        if (hcr == null) {
            if (health.getEnabled() != null && health.getEnabled().booleanValue()) {
                LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
            }
            return;
        }
        if (health.getEnabled() != null) {
            hcr.setEnabled(health.getEnabled());
        }
        if (health.getExcludePattern() != null) {
            hcr.setExcludePattern(health.getExcludePattern());
        }
        if (health.getExposureLevel() != null) {
            hcr.setExposureLevel(health.getExposureLevel());
        }
        if (health.getInitialState() != null) {
            hcr.setInitialState(camelContext.getTypeConverter().convertTo(HealthCheck.State.class, health.getInitialState()));
        }
        if (hcr.isEnabled() && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
            hcr.register(hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
            if (health.getRoutesEnabled() != null) {
                hc.setEnabled(health.getRoutesEnabled());
            }
            hcr.register(hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("producers").orElse((HealthCheckRepository)hcr.resolveById("producers"))) != null) {
            if (health.getProducersEnabled() == null) {
                hc.setEnabled(false);
            } else {
                hc.setEnabled(health.getProducersEnabled());
            }
            hcr.register(hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
            if (health.getConsumersEnabled() != null) {
                hc.setEnabled(health.getConsumersEnabled());
            }
            hcr.register(hc);
        }
        if (hcr.isEnabled() && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
            if (health.getRegistryEnabled() != null) {
                hc.setEnabled(health.getRegistryEnabled());
            }
            hcr.register(hc);
        }
    }

    private void setLraCheckProperties(CamelContext camelContext, OrderedLocationProperties lraProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = lraProperties.getLocation("enabled");
        Object obj = lraProperties.remove("enabled");
        if (ObjectHelper.isNotEmpty(obj)) {
            autoConfiguredProperties.put(loc, "camel.lra.enabled", obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean(camelContext, obj.toString()) : true;
        if (enabled) {
            CamelSagaService css = BaseMainSupport.resolveLraSagaService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, css, lraProperties, "camel.lra.", failIfNotSet, true, autoConfiguredProperties);
            camelContext.addService(css, true, true);
        }
    }

    private void setOtelProperties(CamelContext camelContext, OrderedLocationProperties otelProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = otelProperties.getLocation("enabled");
        Object obj = otelProperties.remove("enabled");
        if (ObjectHelper.isNotEmpty(obj)) {
            autoConfiguredProperties.put(loc, "camel.opentelemetry.enabled", obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean(camelContext, obj.toString()) : true;
        if (enabled) {
            CamelTracingService otel = BaseMainSupport.resolveOtelService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, otel, otelProperties, "camel.opentelemetry.", failIfNotSet, true, autoConfiguredProperties);
            if (camelContext.hasService(CamelTracingService.class) == null) {
                camelContext.addService(otel, true, true);
            }
        }
    }

    private void setMetricsProperties(CamelContext camelContext, OrderedLocationProperties metricsProperties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        boolean enabled;
        String loc = metricsProperties.getLocation("enabled");
        Object obj = metricsProperties.remove("enabled");
        if (ObjectHelper.isNotEmpty(obj)) {
            autoConfiguredProperties.put(loc, "camel.metrics.enabled", obj.toString());
        }
        boolean bl = enabled = obj != null ? CamelContextHelper.parseBoolean(camelContext, obj.toString()) : true;
        if (enabled) {
            CamelMetricsService micrometer = BaseMainSupport.resolveMicrometerService(camelContext);
            MainHelper.setPropertiesOnTarget(camelContext, micrometer, metricsProperties, "camel.metrics.", failIfNotSet, true, autoConfiguredProperties);
            if (camelContext.hasService(CamelMetricsService.class) == null) {
                camelContext.addService(micrometer, true, true);
            }
        }
    }

    private void setDevConsoleProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        for (String key : keys) {
            String name = StringHelper.before(key, ".");
            DevConsole console = camelContext.getCamelContextExtension().getContextPlugin(DevConsoleRegistry.class).resolveById(name);
            if (console == null) {
                throw new IllegalArgumentException("Cannot resolve DevConsole with id: " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, console, config, "camel.devConsole." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setHttpServerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        HttpServerConfigurationProperties server = this.mainConfigurationProperties.httpServer();
        MainHelper.setPropertiesOnTarget(camelContext, server, properties, "camel.server.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        if (!server.isEnabled()) {
            return;
        }
        MainHttpServerFactory sf = BaseMainSupport.resolveMainHttpServerFactory(camelContext);
        Service http = sf.newHttpServer(server);
        camelContext.addService(http, true, true);
    }

    private void setVaultProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        if (this.mainConfigurationProperties.hasVaultConfiguration()) {
            camelContext.setVaultConfiguration(this.mainConfigurationProperties.vault());
        }
        VaultConfiguration target = camelContext.getVaultConfiguration();
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        for (String key : keys) {
            String name = StringHelper.before(key, ".");
            if ("aws".equalsIgnoreCase(name)) {
                target = target.aws();
            }
            if ("gcp".equalsIgnoreCase(name)) {
                target = target.gcp();
            }
            if ("azure".equalsIgnoreCase(name)) {
                target = target.azure();
            }
            if ("hashicorp".equalsIgnoreCase(name)) {
                target = target.hashicorp();
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, target, config, "camel.vault." + name + ".", failIfNotSet, true, autoConfiguredProperties);
        }
    }

    private void setSslProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) {
        SSLConfigurationProperties sslConfig = this.mainConfigurationProperties.sslConfig();
        MainHelper.setPropertiesOnTarget(camelContext, sslConfig, properties, "camel.ssl.", failIfNotSet, true, autoConfiguredProperties);
        if (!sslConfig.isEnabled()) {
            return;
        }
        String password = sslConfig.getKeystorePassword();
        KeyStoreParameters ksp = new KeyStoreParameters();
        ksp.setResource(sslConfig.getKeyStore());
        ksp.setPassword(password);
        KeyManagersParameters kmp = new KeyManagersParameters();
        kmp.setKeyPassword(password);
        kmp.setKeyStore(ksp);
        SSLContextParameters sslContextParameters = BaseMainSupport.createSSLContextParameters(sslConfig, kmp);
        camelContext.setSSLContextParameters(sslContextParameters);
    }

    private static SSLContextParameters createSSLContextParameters(SSLConfigurationProperties sslConfig, KeyManagersParameters kmp) {
        TrustManagersParameters tmp = null;
        if (sslConfig.getTrustStore() != null) {
            KeyStoreParameters tsp = new KeyStoreParameters();
            tsp.setResource(sslConfig.getTrustStore());
            tsp.setPassword(sslConfig.getTrustStorePassword());
            tmp = new TrustManagersParameters();
            tmp.setKeyStore(tsp);
        }
        SSLContextServerParameters scsp = new SSLContextServerParameters();
        scsp.setClientAuthentication(sslConfig.getClientAuthentication());
        SSLContextParameters sslContextParameters = new SSLContextParameters();
        sslContextParameters.setKeyManagers(kmp);
        sslContextParameters.setTrustManagers(tmp);
        sslContextParameters.setServerParameters(scsp);
        return sslContextParameters;
    }

    private void setDebuggerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        DebuggerConfigurationProperties config = this.mainConfigurationProperties.debuggerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.debug.", failIfNotSet, true, autoConfiguredProperties);
        if (!config.isEnabled() && !config.isStandby()) {
            return;
        }
        camelContext.setSourceLocationEnabled(true);
        camelContext.setMessageHistory(true);
        camelContext.setDebugging(config.isEnabled());
        camelContext.setDebugStandby(config.isStandby());
        final BacklogDebugger debugger = DefaultBacklogDebugger.createDebugger(camelContext);
        debugger.setStandby(config.isStandby());
        debugger.setInitialBreakpoints(config.getBreakpoints());
        debugger.setSingleStepIncludeStartEnd(config.isSingleStepIncludeStartEnd());
        debugger.setBodyMaxChars(config.getBodyMaxChars());
        debugger.setBodyIncludeStreams(config.isBodyIncludeStreams());
        debugger.setBodyIncludeFiles(config.isBodyIncludeFiles());
        debugger.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        debugger.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        debugger.setIncludeException(config.isIncludeException());
        debugger.setLoggingLevel(config.getLoggingLevel().name());
        debugger.setSuspendMode(config.isWaitForAttach());
        debugger.setFallbackTimeout(config.getFallbackTimeout());
        if (config.isJmxConnectorEnabled()) {
            DebuggerJmxConnectorService connector = new DebuggerJmxConnectorService();
            connector.setCreateConnector(true);
            connector.setRegistryPort(config.getJmxConnectorPort());
            camelContext.addService(connector);
        }
        camelContext.addLifecycleStrategy(new LifecycleStrategySupport(){

            @Override
            public void onContextStarted(CamelContext context) {
                if (!debugger.isStandby()) {
                    debugger.enableDebugger();
                }
            }

            @Override
            public void onContextStopping(CamelContext context) {
                debugger.disableDebugger();
            }
        });
        camelContext.addService(debugger);
    }

    private void setTracerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        TracerConfigurationProperties config = this.mainConfigurationProperties.tracerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.trace.", failIfNotSet, true, autoConfiguredProperties);
        if (!config.isEnabled() && !config.isStandby()) {
            return;
        }
        camelContext.setSourceLocationEnabled(true);
        camelContext.setBacklogTracing(config.isEnabled());
        camelContext.setBacklogTracingStandby(config.isStandby());
        camelContext.setBacklogTracingTemplates(config.isTraceTemplates());
        org.apache.camel.impl.debugger.BacklogTracer tracer = org.apache.camel.impl.debugger.BacklogTracer.createTracer(camelContext);
        tracer.setEnabled(config.isEnabled());
        tracer.setStandby(config.isStandby());
        tracer.setBacklogSize(config.getBacklogSize());
        tracer.setRemoveOnDump(config.isRemoveOnDump());
        tracer.setBodyMaxChars(config.getBodyMaxChars());
        tracer.setBodyIncludeStreams(config.isBodyIncludeStreams());
        tracer.setBodyIncludeFiles(config.isBodyIncludeFiles());
        tracer.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        tracer.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        tracer.setIncludeException(config.isIncludeException());
        tracer.setTraceRests(config.isTraceRests());
        tracer.setTraceTemplates(config.isTraceTemplates());
        tracer.setTracePattern(config.getTracePattern());
        tracer.setTraceFilter(config.getTraceFilter());
        camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, tracer);
        camelContext.addService(tracer);
    }

    private void setRouteControllerProperties(CamelContext camelContext, OrderedLocationProperties properties, boolean failIfNotSet, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        RouteControllerConfigurationProperties config = this.mainConfigurationProperties.routeControllerConfig();
        MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.routeController.", failIfNotSet, true, autoConfiguredProperties);
        if (config.isEnabled()) {
            SupervisingRouteController src = camelContext.getRouteController().supervising();
            if (config.getIncludeRoutes() != null) {
                src.setIncludeRoutes(config.getIncludeRoutes());
            }
            if (config.getExcludeRoutes() != null) {
                src.setExcludeRoutes(config.getExcludeRoutes());
            }
            if (config.getThreadPoolSize() > 0) {
                src.setThreadPoolSize(config.getThreadPoolSize());
            }
            if (config.getBackOffDelay() > 0L) {
                src.setBackOffDelay(config.getBackOffDelay());
            }
            if (config.getInitialDelay() > 0L) {
                src.setInitialDelay(config.getInitialDelay());
            }
            if (config.getBackOffMaxAttempts() > 0L) {
                src.setBackOffMaxAttempts(config.getBackOffMaxAttempts());
            }
            if (config.getBackOffMaxDelay() > 0L) {
                src.setBackOffMaxDelay(config.getBackOffDelay());
            }
            if (config.getBackOffMaxElapsedTime() > 0L) {
                src.setBackOffMaxElapsedTime(config.getBackOffMaxElapsedTime());
            }
            if (config.getBackOffMultiplier() > 0.0) {
                src.setBackOffMultiplier(config.getBackOffMultiplier());
            }
            src.setUnhealthyOnExhausted(config.isUnhealthyOnExhausted());
            src.setUnhealthyOnRestarting(config.isUnhealthyOnRestarting());
        }
    }

    private void bindBeansToRegistry(CamelContext camelContext, OrderedLocationProperties properties, String optionPrefix, boolean failIfNotSet, boolean logSummary, boolean ignoreCase, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Object bean;
        LinkedHashSet keys = new LinkedHashSet(properties.asMap().keySet());
        Set beansDot = properties.keySet().stream().map(k -> StringHelper.before(k.toString(), ".", k.toString())).filter(k -> k.indexOf(91) == -1).collect(Collectors.toSet());
        Set beansMap = properties.keySet().stream().map(k -> StringHelper.before(k.toString(), "[", k.toString())).filter(k -> k.indexOf(46) == -1).collect(Collectors.toSet());
        for (String key2 : keys) {
            if (key2.indexOf(46) != -1 || key2.indexOf(91) != -1) continue;
            Object value = properties.remove(key2);
            Object bean2 = PropertyBindingSupport.resolveBean(camelContext, value);
            if (bean2 == null) {
                throw new IllegalArgumentException("Cannot create/resolve bean with name " + key2 + " from value: " + String.valueOf(value));
            }
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)key2, (Object)ObjectHelper.classCanonicalName(bean2));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)key2, (Object)ObjectHelper.classCanonicalName(bean2));
            }
            camelContext.getRegistry().bind(key2, bean2);
        }
        for (String name : beansMap) {
            Cloneable bean3;
            if (camelContext.getRegistry().lookupByName(name) != null) continue;
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + "[", "]", false);
            boolean list = config.keySet().stream().map(Object::toString).allMatch(StringHelper::isDigit);
            Cloneable cloneable = bean3 = list ? new ArrayList() : new LinkedHashMap();
            if (logSummary) {
                LOG.info("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName(bean3));
            } else {
                LOG.debug("Binding bean: {} (type: {}) to the registry", (Object)name, (Object)ObjectHelper.classCanonicalName(bean3));
            }
            camelContext.getRegistry().bind(name, bean3);
        }
        for (String name : beansDot) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + ".");
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
        for (String name : beansMap) {
            bean = camelContext.getRegistry().lookupByName(name);
            if (bean == null) {
                throw new IllegalArgumentException("Cannot resolve bean with name " + name);
            }
            OrderedLocationProperties config = MainHelper.extractProperties(properties, name + "[", "]", true, key -> {
                if (key.startsWith(name + "[")) {
                    return key.substring(name.length());
                }
                return key;
            });
            MainHelper.setPropertiesOnTarget(camelContext, bean, config, optionPrefix + name + ".", failIfNotSet, ignoreCase, autoConfiguredProperties);
        }
    }

    protected void autoConfigurationPropertiesComponent(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        Properties propENV;
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled() && !(propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("ENV", propENV);
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.properties."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.component.properties.")) continue;
            int dot = key.indexOf(46, 26);
            String option = dot == -1 ? "" : key.substring(dot + 1);
            String value = prop.getProperty(key, "");
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation(key);
            properties.put(loc, MainHelper.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring properties component from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, camelContext.getPropertiesComponent(), properties, "camel.component.properties.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.component.properties.{}={} on object: {}", new Object[]{k, v, camelContext.getPropertiesComponent()})));
        }
    }

    protected void autoConfigurationMainConfiguration(CamelContext camelContext, MainConfigurationProperties config, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        OrderedLocationProperties prop = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."), MainHelper::optionKey);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Properties propENV = MainHelper.loadEnvironmentVariablesAsProperties(new String[]{"camel.main."});
            propENV.remove("camel.main.initial-properties-location".replace('-', '.'));
            propENV.remove("camel.main.override-properties-location".replace('-', '.'));
            propENV.remove("camel.main.property-placeholder-location".replace('-', '.'));
            if (!propENV.isEmpty()) {
                prop.putAll("ENV", propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled()) {
            Properties propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.main."});
            propJVM.remove("camel.main.initial-properties-location");
            propJVM.remove(StringHelper.dashToCamelCase("camel.main.initial-properties-location"));
            propJVM.remove("camel.main.override-properties-location");
            propJVM.remove(StringHelper.dashToCamelCase("camel.main.override-properties-location"));
            propJVM.remove("camel.main.property-placeholder-location");
            propJVM.remove(StringHelper.dashToCamelCase("camel.main.property-placeholder-location"));
            if (!propJVM.isEmpty()) {
                prop.putAll("SYS", propJVM);
            }
        }
        OrderedLocationProperties properties = new OrderedLocationProperties();
        for (String key : prop.stringPropertyNames()) {
            if (!key.startsWith("camel.main.")) continue;
            String value = prop.getProperty(key);
            String option = key.substring(11);
            MainHelper.validateOptionAndValue(key, option, value);
            String loc = prop.getLocation(key);
            properties.put(loc, MainHelper.optionKey(option), value);
        }
        if (!properties.isEmpty()) {
            LOG.debug("Auto-configuring main from loaded properties: {}", (Object)properties.size());
            MainHelper.setPropertiesOnTarget(camelContext, config, properties, "camel.main.", this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> LOG.warn("Property not auto-configured: camel.main.{}={} on bean: {}", new Object[]{k, v, config})));
        }
    }

    protected void autoConfigurationFromProperties(CamelContext camelContext, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        Properties propJVM;
        OrderedLocationProperties prop = new OrderedLocationProperties();
        OrderedLocationProperties propPC = (OrderedLocationProperties)camelContext.getPropertiesComponent().loadProperties(name -> name.startsWith("camel."));
        prop.putAll(propPC);
        if (this.mainConfigurationProperties.isAutoConfigurationEnvironmentVariablesEnabled()) {
            Map<String, String> env = MainHelper.filterEnvVariables(new String[]{"camel.component.", "camel.dataformat.", "camel.language."});
            LOG.debug("Gathered {} ENV variables to configure components, dataformats, languages", (Object)env.size());
            OrderedProperties propENV = new OrderedProperties();
            this.helper.addComponentEnvVariables(env, propENV, false);
            this.helper.addDataFormatEnvVariables(env, propENV, false);
            this.helper.addLanguageEnvVariables(env, propENV, false);
            if (!env.isEmpty()) {
                LOG.debug("Remaining {} ENV variables to configure custom components, dataformats, languages", (Object)env.size());
                this.helper.addComponentEnvVariables(env, propENV, true);
                this.helper.addDataFormatEnvVariables(env, propENV, true);
                this.helper.addLanguageEnvVariables(env, propENV, true);
            }
            if (!((Properties)propENV).isEmpty()) {
                prop.putAll("ENV", propENV);
            }
        }
        if (this.mainConfigurationProperties.isAutoConfigurationSystemPropertiesEnabled() && !(propJVM = MainHelper.loadJvmSystemPropertiesAsProperties(new String[]{"camel.component.", "camel.dataformat.", "camel.language."})).isEmpty()) {
            prop.putAll("SYS", propJVM);
        }
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        for (String key : prop.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            String loc = prop.getLocation(key);
            this.wildcardProperties.put(loc, key, prop.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            prop.remove(key);
        }
        this.doAutoConfigurationFromProperties(camelContext, prop, properties, false, autoConfiguredProperties);
    }

    protected void autoConfigurationFromReloadedProperties(CamelContext camelContext, OrderedLocationProperties reloadedProperties) throws Exception {
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        for (String key : reloadedProperties.stringPropertyNames()) {
            if (!key.contains("*")) continue;
            String loc = reloadedProperties.getLocation(key);
            this.wildcardProperties.put(loc, key, reloadedProperties.getProperty(key));
        }
        for (String key : this.wildcardProperties.stringPropertyNames()) {
            reloadedProperties.remove(key);
        }
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        this.doAutoConfigurationFromProperties(camelContext, reloadedProperties, properties, true, autoConfiguredProperties);
        if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
            BaseMainSupport.logConfigurationSummary(autoConfiguredProperties);
        }
    }

    protected void doAutoConfigurationFromProperties(CamelContext camelContext, OrderedLocationProperties prop, Map<PropertyOptionKey, OrderedLocationProperties> properties, boolean reload, OrderedLocationProperties autoConfiguredProperties) throws Exception {
        for (String string : prop.stringPropertyNames()) {
            MainHelper.computeProperties("camel.component.", string, prop, properties, name -> {
                Component target;
                if (reload) {
                    camelContext.removeComponent((String)name);
                }
                if ((target = camelContext.getComponent((String)name)) == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find component with name " + name + ". Make sure you have the component on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.dataformat.", string, prop, properties, name -> {
                DataFormat target = camelContext.resolveDataFormat((String)name);
                if (target == null) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find dataformat with name " + name + ". Make sure you have the dataformat on the classpath");
                }
                return Collections.singleton(target);
            });
            MainHelper.computeProperties("camel.language.", string, prop, properties, name -> {
                Language target;
                try {
                    target = camelContext.resolveLanguage((String)name);
                }
                catch (NoSuchLanguageException e) {
                    throw new IllegalArgumentException("Error configuring property: " + key + " because cannot find language with name " + name + ". Make sure you have the language on the classpath");
                }
                return Collections.singleton(target);
            });
        }
        if (!properties.isEmpty()) {
            long total = properties.values().stream().mapToLong(Map::size).sum();
            LOG.debug("Auto-configuring {} components/dataformat/languages from loaded properties: {}", (Object)properties.size(), (Object)total);
        }
        for (Map.Entry entry : properties.entrySet()) {
            MainHelper.setPropertiesOnTarget(camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
        }
        if (!properties.isEmpty()) {
            for (Map.Entry entry : properties.entrySet()) {
                PropertyOptionKey pok = (PropertyOptionKey)entry.getKey();
                OrderedLocationProperties values = (OrderedLocationProperties)entry.getValue();
                values.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    String stringValue = v != null ? v.toString() : null;
                    LOG.warn("Property ({}={}) not auto-configured with name: {} on bean: {} with value: {}", new Object[]{pok.getOptionPrefix() + "." + String.valueOf(k), stringValue, k, pok.getInstance(), stringValue});
                }));
            }
        }
    }

    protected void autowireWildcardProperties(CamelContext camelContext) {
        if (this.wildcardProperties.isEmpty()) {
            return;
        }
        for (String name : camelContext.getComponentNames()) {
            Component comp = camelContext.getComponent(name);
            this.doAutowireWildcardProperties(name, comp);
        }
        camelContext.addLifecycleStrategy(new LifecycleStrategySupport(){

            @Override
            public void onComponentAdd(String name, Component component) {
                BaseMainSupport.this.doAutowireWildcardProperties(name, component);
            }
        });
        this.wildcardProperties.clear();
    }

    protected void doAutowireWildcardProperties(String name, Component component) {
        LinkedHashMap<PropertyOptionKey, OrderedLocationProperties> properties = new LinkedHashMap<PropertyOptionKey, OrderedLocationProperties>();
        OrderedLocationProperties autoConfiguredProperties = new OrderedLocationProperties();
        String match = ("camel.component." + name).toLowerCase(Locale.ENGLISH);
        for (String string : this.wildcardProperties.stringPropertyNames()) {
            String mKey = string.substring(0, string.indexOf(42)).toLowerCase(Locale.ENGLISH);
            if (!match.startsWith(mKey)) continue;
            MainHelper.computeProperties("camel.component.", string, this.wildcardProperties, properties, s -> Collections.singleton(component));
        }
        try {
            for (Map.Entry entry : properties.entrySet()) {
                MainHelper.setPropertiesOnTarget(this.camelContext, ((PropertyOptionKey)entry.getKey()).getInstance(), (OrderedLocationProperties)entry.getValue(), ((PropertyOptionKey)entry.getKey()).getOptionPrefix(), this.mainConfigurationProperties.isAutoConfigurationFailFast(), true, autoConfiguredProperties);
            }
            if (this.mainConfigurationProperties.isAutoConfigurationLogSummary() && !autoConfiguredProperties.isEmpty()) {
                boolean header = false;
                for (Map.Entry entry : autoConfiguredProperties.entrySet()) {
                    String k = entry.getKey().toString();
                    Object v = entry.getValue();
                    String loc = LocationHelper.locationSummary(autoConfiguredProperties, k);
                    boolean debug = loc.contains("[camel-main]");
                    if (debug && !LOG.isDebugEnabled()) continue;
                    if (!header) {
                        LOG.info("Auto-configuration component {} summary", (Object)name);
                        header = true;
                    }
                    MainHelper.sensitiveAwareLogging(LOG, k, v, loc, debug);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }

    private static CamelSagaService resolveLraSagaService(CamelContext camelContext) throws Exception {
        CamelSagaService answer = camelContext.hasService(CamelSagaService.class);
        if (answer == null) {
            answer = camelContext.getRegistry().findSingleByType(CamelSagaService.class);
        }
        if (answer == null) {
            answer = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("lra-saga-service", CamelSagaService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find LRASagaService on classpath. Add camel-lra to classpath."));
        }
        return answer;
    }

    private static CamelTracingService resolveOtelService(CamelContext camelContext) throws Exception {
        CamelTracingService answer = camelContext.hasService(CamelTracingService.class);
        if (answer == null) {
            answer = camelContext.getRegistry().findSingleByType(CamelTracingService.class);
        }
        if (answer == null) {
            answer = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("opentelemetry-tracer", CamelTracingService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find OpenTelemetryTracer on classpath. Add camel-opentelemetry to classpath."));
        }
        return answer;
    }

    private static CamelMetricsService resolveMicrometerService(CamelContext camelContext) throws Exception {
        CamelMetricsService answer = camelContext.hasService(CamelMetricsService.class);
        if (answer == null) {
            answer = camelContext.getRegistry().findSingleByType(CamelMetricsService.class);
        }
        if (answer == null) {
            answer = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("micrometer-prometheus", CamelMetricsService.class).orElseThrow(() -> new IllegalArgumentException("Cannot find CamelMetricsService on classpath. Add camel-micrometer-prometheus to classpath."));
        }
        return answer;
    }

    private static MainHttpServerFactory resolveMainHttpServerFactory(CamelContext camelContext) {
        MainHttpServerFactory answer = camelContext.getRegistry().findSingleByType(MainHttpServerFactory.class);
        if (answer == null) {
            answer = camelContext.getCamelContextExtension().getBootstrapFactoryFinder().newInstance("platform-http-server", MainHttpServerFactory.class).orElseThrow(() -> new IllegalArgumentException("Cannot find MainHttpServerFactory on classpath. Add camel-platform-http-main to classpath."));
        }
        return answer;
    }

    private static /* synthetic */ boolean lambda$doConfigureCamelContextFromMainConfiguration$6(String pattern, File f) {
        return StringHelper.matches(pattern, f.getName());
    }

    private static final class PropertyPlaceholderListener
    implements PropertiesLookupListener {
        private final OrderedLocationProperties olp;

        public PropertyPlaceholderListener(OrderedLocationProperties olp) {
            this.olp = olp;
        }

        @Override
        public void onLookup(String name, String value, String defaultValue, String source) {
            if (source == null) {
                source = "unknown";
            }
            this.olp.put(source, name, value, defaultValue);
        }
    }

    private static class PlaceholderSummaryEventNotifier
    extends SimpleEventNotifierSupport
    implements NonManagedService {
        private final OrderedLocationProperties propertyPlaceholders;

        public PlaceholderSummaryEventNotifier(OrderedLocationProperties propertyPlaceholders) {
            this.propertyPlaceholders = propertyPlaceholders;
        }

        @Override
        public boolean isEnabled(CamelEvent event) {
            return event instanceof CamelEvent.CamelContextRoutesStartedEvent;
        }

        @Override
        public void notify(CamelEvent event) throws Exception {
            if (!this.propertyPlaceholders.isEmpty()) {
                boolean header = true;
                for (Map.Entry entry : this.propertyPlaceholders.entrySet()) {
                    String k = entry.getKey().toString();
                    Object v = entry.getValue();
                    Object dv = this.propertyPlaceholders.getDefaultValue(k);
                    boolean same = ObjectHelper.equal(v, dv);
                    boolean skip = "templateId".equals(k);
                    if (same || skip) continue;
                    if (header) {
                        LOG.info("Property-placeholders summary");
                        header = false;
                    }
                    String loc = LocationHelper.locationSummary(this.propertyPlaceholders, k);
                    if (SensitiveUtils.containsSensitive(k)) {
                        LOG.info("    {} {}=xxxxxx", (Object)loc, (Object)k);
                        continue;
                    }
                    LOG.info("    {} {}={}", new Object[]{loc, k, v});
                }
            }
        }
    }
}

