/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.TypeConverters;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.console.DevConsole;
import org.apache.camel.console.DevConsoleRegistry;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.debugger.BacklogTracer;
import org.apache.camel.impl.engine.DefaultCompileStrategy;
import org.apache.camel.impl.engine.PooledExchangeFactory;
import org.apache.camel.impl.engine.PooledProcessorExchangeFactory;
import org.apache.camel.impl.engine.PrototypeExchangeFactory;
import org.apache.camel.impl.engine.PrototypeProcessorExchangeFactory;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.spi.CompileStrategy;
import org.apache.camel.spi.ContextReloadStrategy;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DumpRoutesStrategy;
import org.apache.camel.spi.EndpointServiceRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementObjectNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.PeriodTaskScheduler;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.ThreadPoolFactory;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.support.DefaultContextReloadStrategy;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.OffUuidGenerator;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.RouteWatcherReloadStrategy;
import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.support.jsse.GlobalSSLContextParametersSupplier;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.support.startup.BacklogStartupStepRecorder;
import org.apache.camel.support.startup.LoggingStartupStepRecorder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.vault.AwsVaultConfiguration;
import org.apache.camel.vault.AzureVaultConfiguration;
import org.apache.camel.vault.GcpVaultConfiguration;
import org.apache.camel.vault.HashicorpVaultConfiguration;
import org.apache.camel.vault.VaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultConfigurationConfigurer {
    public static final Logger LOG = LoggerFactory.getLogger(DefaultConfigurationConfigurer.class);

    private DefaultConfigurationConfigurer() {
    }

    public static void configure(CamelContext camelContext, DefaultConfigurationProperties<?> config) throws Exception {
        ServiceSupport reloader;
        ExtendedCamelContext ecc = camelContext.getCamelContextExtension();
        if (config.getStartupRecorder() != null) {
            if ("false".equals(config.getStartupRecorder())) {
                ecc.getStartupStepRecorder().setEnabled(false);
            } else if ("logging".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof LoggingStartupStepRecorder)) {
                    ecc.setStartupStepRecorder(new LoggingStartupStepRecorder());
                }
            } else if ("backlog".equals(config.getStartupRecorder())) {
                if (!(ecc.getStartupStepRecorder() instanceof BacklogStartupStepRecorder)) {
                    ecc.setStartupStepRecorder(new BacklogStartupStepRecorder());
                }
            } else if ("java-flight-recorder".equals(config.getStartupRecorder()) && !ecc.getStartupStepRecorder().getClass().getName().startsWith("org.apache.camel.startup.jfr")) {
                throw new IllegalArgumentException("Cannot find Camel Java Flight Recorder on classpath. Add camel-jfr to classpath.");
            }
        }
        ecc.getStartupStepRecorder().setMaxDepth(config.getStartupRecorderMaxDepth());
        ecc.getStartupStepRecorder().setRecording(config.isStartupRecorderRecording());
        ecc.getStartupStepRecorder().setStartupRecorderDuration(config.getStartupRecorderDuration());
        ecc.getStartupStepRecorder().setRecordingDir(config.getStartupRecorderDir());
        ecc.getStartupStepRecorder().setRecordingProfile(config.getStartupRecorderProfile());
        PluginHelper.getBeanPostProcessor(ecc).setEnabled(config.isBeanPostProcessorEnabled());
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(ecc);
        beanIntrospection.setExtendedStatistics(config.isBeanIntrospectionExtendedStatistics());
        if (config.getBeanIntrospectionLoggingLevel() != null) {
            beanIntrospection.setLoggingLevel(config.getBeanIntrospectionLoggingLevel());
        }
        beanIntrospection.afterPropertiesConfigured(camelContext);
        if ("pooled".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory(new PooledExchangeFactory());
            ecc.setProcessorExchangeFactory(new PooledProcessorExchangeFactory());
        } else if ("prototype".equals(config.getExchangeFactory())) {
            ecc.setExchangeFactory(new PrototypeExchangeFactory());
            ecc.setProcessorExchangeFactory(new PrototypeProcessorExchangeFactory());
        }
        ecc.getExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getProcessorExchangeFactory().setCapacity(config.getExchangeFactoryCapacity());
        ecc.getExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        ecc.getProcessorExchangeFactory().setStatisticsEnabled(config.isExchangeFactoryStatisticsEnabled());
        if (!config.isJmxEnabled()) {
            camelContext.disableJMX();
        }
        if (config.getName() != null) {
            ecc.setName(config.getName());
        }
        if (config.getDescription() != null) {
            ecc.setDescription(config.getDescription());
        }
        if (config.getStartupSummaryLevel() != null) {
            camelContext.setStartupSummaryLevel(config.getStartupSummaryLevel());
        }
        if (config.getShutdownTimeout() > 0) {
            camelContext.getShutdownStrategy().setTimeout(config.getShutdownTimeout());
        }
        camelContext.getShutdownStrategy().setSuppressLoggingOnTimeout(config.isShutdownSuppressLoggingOnTimeout());
        camelContext.getShutdownStrategy().setShutdownNowOnTimeout(config.isShutdownNowOnTimeout());
        camelContext.getShutdownStrategy().setShutdownRoutesInReverseOrder(config.isShutdownRoutesInReverseOrder());
        camelContext.getShutdownStrategy().setLogInflightExchangesOnTimeout(config.isShutdownLogInflightExchangesOnTimeout());
        camelContext.getInflightRepository().setInflightBrowseEnabled(config.isInflightRepositoryBrowseEnabled());
        if (config.getLogDebugMaxChars() != 0) {
            camelContext.getGlobalOptions().put("CamelLogDebugBodyMaxChars", Integer.toString(config.getLogDebugMaxChars()));
        }
        camelContext.setStreamCaching(config.isStreamCachingEnabled());
        camelContext.getStreamCachingStrategy().setAllowClasses(config.getStreamCachingAllowClasses());
        camelContext.getStreamCachingStrategy().setDenyClasses(config.getStreamCachingDenyClasses());
        camelContext.getStreamCachingStrategy().setSpoolEnabled(config.isStreamCachingSpoolEnabled());
        camelContext.getStreamCachingStrategy().setAnySpoolRules(config.isStreamCachingAnySpoolRules());
        camelContext.getStreamCachingStrategy().setBufferSize(config.getStreamCachingBufferSize());
        camelContext.getStreamCachingStrategy().setRemoveSpoolDirectoryWhenStopping(config.isStreamCachingRemoveSpoolDirectoryWhenStopping());
        camelContext.getStreamCachingStrategy().setSpoolCipher(config.getStreamCachingSpoolCipher());
        if (config.getStreamCachingSpoolDirectory() != null) {
            camelContext.getStreamCachingStrategy().setSpoolDirectory(config.getStreamCachingSpoolDirectory());
        }
        if (config.getStreamCachingSpoolThreshold() != 0L) {
            camelContext.getStreamCachingStrategy().setSpoolThreshold(config.getStreamCachingSpoolThreshold());
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryLimit() != null) {
            StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;
            if ("Committed".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed;
            } else if ("Max".equalsIgnoreCase(config.getStreamCachingSpoolUsedHeapMemoryLimit())) {
                limit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
            } else {
                throw new IllegalArgumentException("Invalid option " + config.getStreamCachingSpoolUsedHeapMemoryLimit() + " must either be Committed or Max");
            }
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryLimit(limit);
        }
        if (config.getStreamCachingSpoolUsedHeapMemoryThreshold() != 0) {
            camelContext.getStreamCachingStrategy().setSpoolUsedHeapMemoryThreshold(config.getStreamCachingSpoolUsedHeapMemoryThreshold());
        }
        if ("default".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new DefaultUuidGenerator());
        } else if ("short".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new ShortUuidGenerator());
        } else if ("classic".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new ClassicUuidGenerator());
        } else if ("simple".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new SimpleUuidGenerator());
        } else if ("off".equals(config.getUuidGenerator())) {
            camelContext.setUuidGenerator(new OffUuidGenerator());
            LOG.warn("Using OffUuidGenerator (Only intended for development purposes)");
        }
        camelContext.setLogMask(config.isLogMask());
        camelContext.setLogExhaustedMessageBody(config.isLogExhaustedMessageBody());
        camelContext.setAutoStartup(config.isAutoStartup());
        camelContext.setAllowUseOriginalMessage(config.isAllowUseOriginalMessage());
        camelContext.setCaseInsensitiveHeaders(config.isCaseInsensitiveHeaders());
        camelContext.setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.setUseBreadcrumb(config.isUseBreadcrumb());
        camelContext.setUseDataType(config.isUseDataType());
        camelContext.setDumpRoutes(config.getDumpRoutes());
        camelContext.setUseMDCLogging(config.isUseMdcLogging());
        camelContext.setMDCLoggingKeysPattern(config.getMdcLoggingKeysPattern());
        camelContext.setLoadTypeConverters(config.isLoadTypeConverters());
        camelContext.setTypeConverterStatisticsEnabled(config.isTypeConverterStatisticsEnabled());
        camelContext.setLoadHealthChecks(config.isLoadHealthChecks());
        camelContext.setDevConsole(config.isDevConsoleEnabled());
        camelContext.setModeline(config.isModeline());
        if (config.isRoutesReloadEnabled()) {
            reloader = new RouteWatcherReloadStrategy(config.getRoutesReloadDirectory(), config.isRoutesReloadDirectoryRecursive());
            reloader.setPattern(config.getRoutesReloadPattern());
            reloader.setRemoveAllRoutes(config.isRoutesReloadRemoveAllRoutes());
            camelContext.addService(reloader);
        }
        if (config.getDumpRoutes() != null) {
            DumpRoutesStrategy drs = camelContext.getCamelContextExtension().getContextPlugin(DumpRoutesStrategy.class);
            drs.setInclude(config.getDumpRoutesInclude());
            drs.setLog(config.isDumpRoutesLog());
            drs.setUriAsParameters(config.isDumpRoutesUriAsParameters());
            drs.setGeneratedIds(config.isDumpRoutesGeneratedIds());
            drs.setResolvePlaceholders(config.isDumpRoutesResolvePlaceholders());
            drs.setOutput(config.getDumpRoutesOutput());
        }
        if (config.isContextReloadEnabled() && camelContext.hasService(ContextReloadStrategy.class) == null) {
            reloader = new DefaultContextReloadStrategy();
            camelContext.addService(reloader);
        }
        if (camelContext.getManagementStrategy().getManagementAgent() != null) {
            camelContext.getManagementStrategy().getManagementAgent().setEndpointRuntimeStatisticsEnabled(config.isEndpointRuntimeStatisticsEnabled());
            camelContext.getManagementStrategy().getManagementAgent().setLoadStatisticsEnabled(config.isLoadStatisticsEnabled());
            camelContext.getManagementStrategy().getManagementAgent().setStatisticsLevel(config.getJmxManagementStatisticsLevel());
            camelContext.getManagementStrategy().getManagementAgent().setMBeansLevel(config.getJmxManagementMBeansLevel());
            camelContext.getManagementStrategy().getManagementAgent().setManagementNamePattern(config.getJmxManagementNamePattern());
            camelContext.getManagementStrategy().getManagementAgent().setUpdateRouteEnabled(config.isJmxUpdateRouteEnabled());
            camelContext.getManagementStrategy().getManagementAgent().setRegisterRoutesCreateByKamelet(config.isJmxManagementRegisterRoutesCreateByKamelet());
            camelContext.getManagementStrategy().getManagementAgent().setRegisterRoutesCreateByTemplate(config.isJmxManagementRegisterRoutesCreateByTemplate());
        }
        if (config.isCamelEventsTimestampEnabled()) {
            camelContext.getManagementStrategy().getEventFactory().setTimestampEnabled(true);
        }
        if (config.getGlobalOptions() != null) {
            Map<String, String> map = camelContext.getGlobalOptions();
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.putAll(config.getGlobalOptions());
            camelContext.setGlobalOptions(map);
        }
        camelContext.getGlobalEndpointConfiguration().setAutowiredEnabled(config.isAutowiredEnabled());
        camelContext.getGlobalEndpointConfiguration().setBridgeErrorHandler(config.isEndpointBridgeErrorHandler());
        camelContext.getGlobalEndpointConfiguration().setLazyStartProducer(config.isEndpointLazyStartProducer());
        if (config.isMessageHistory()) {
            camelContext.setMessageHistory(true);
        }
        if (config.isSourceLocationEnabled()) {
            camelContext.setSourceLocationEnabled(true);
        }
        camelContext.setTracing(config.isTracing());
        camelContext.setTracingStandby(config.isTracingStandby());
        camelContext.setTracingPattern(config.getTracingPattern());
        camelContext.setTracingLoggingFormat(config.getTracingLoggingFormat());
        camelContext.setTracingTemplates(config.isTracingTemplates());
        if (config.getThreadNamePattern() != null) {
            camelContext.getExecutorServiceManager().setThreadNamePattern(config.getThreadNamePattern());
        }
        if (config.getCompileWorkDir() != null) {
            CompileStrategy cs = ecc.getContextPlugin(CompileStrategy.class);
            if (cs == null) {
                cs = new DefaultCompileStrategy();
                ecc.addContextPlugin(CompileStrategy.class, cs);
            }
            cs.setWorkDir(config.getCompileWorkDir());
        }
        if (config.getRouteFilterIncludePattern() != null || config.getRouteFilterExcludePattern() != null) {
            camelContext.getCamelContextExtension().getContextPlugin(Model.class).setRouteFilterPattern(config.getRouteFilterIncludePattern(), config.getRouteFilterExcludePattern());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void afterConfigure(CamelContext camelContext) throws Exception {
        HashicorpVaultConfiguration hashicorp;
        AzureVaultConfiguration azure;
        GcpVaultConfiguration gcpVaultConfiguration;
        DevConsoleRegistry devConsoleRegistry;
        Set<HealthCheckRepository> repositories;
        void var44_51;
        HealthCheckRegistry healthCheckRegistry;
        GlobalSSLContextParametersSupplier globalSSLContextParametersSupplier;
        Map<String, ServiceRegistry> serviceRegistries;
        Set<RoutePolicyFactory> rpfs;
        Set<CamelClusterService> csss;
        Set<EndpointStrategy> ess;
        Set<EventNotifier> ens;
        Set<TypeConverters> tcs;
        ExchangeFactory exf;
        ShutdownStrategy ss;
        ReactiveExecutor re;
        MessageHistoryFactory mhf;
        NodeIdFactory nif;
        Debugger debugger;
        ProcessorFactory pf;
        ThreadPoolFactory tpf;
        ExecutorServiceManager esm;
        UuidGenerator ug;
        RouteController rc;
        FactoryFinderResolver ffr;
        ClassResolver cr;
        ModelJAXBContextFactory mjcf;
        EndpointServiceRegistry esr;
        RuntimeEndpointRegistry rer;
        UnitOfWorkFactory uowf;
        EventFactory ef;
        ManagementObjectNameStrategy mons;
        ManagementStrategy ms;
        AsyncProcessorAwaitManager apam;
        InflightRepository ir;
        BacklogDebugger bd;
        BacklogTracer bt;
        PropertiesComponent pc;
        VariableRepositoryFactory vrf;
        CliConnectorFactory ccf;
        Registry registry = camelContext.getRegistry();
        ManagementStrategy managementStrategy = camelContext.getManagementStrategy();
        StartupStepRecorder ssr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, StartupStepRecorder.class);
        if (ssr != null) {
            camelContext.getCamelContextExtension().setStartupStepRecorder(ssr);
        }
        if ((ccf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, CliConnectorFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(CliConnectorFactory.class, ccf);
        }
        if ((vrf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, VariableRepositoryFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(VariableRepositoryFactory.class, vrf);
        }
        if ((pc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, PropertiesComponent.class)) != null) {
            camelContext.setPropertiesComponent(pc);
        }
        if ((bt = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogTracer.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(BacklogTracer.class, bt);
        }
        if ((bd = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, BacklogDebugger.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(BacklogDebugger.class, bd);
        }
        if ((ir = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, InflightRepository.class)) != null) {
            camelContext.setInflightRepository(ir);
        }
        if ((apam = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AsyncProcessorAwaitManager.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(AsyncProcessorAwaitManager.class, apam);
        }
        if ((ms = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementStrategy.class)) != null) {
            camelContext.setManagementStrategy(ms);
        }
        if ((mons = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ManagementObjectNameStrategy.class)) != null) {
            managementStrategy.setManagementObjectNameStrategy(mons);
        }
        if ((ef = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EventFactory.class)) != null) {
            managementStrategy.setEventFactory(ef);
        }
        if ((uowf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UnitOfWorkFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(UnitOfWorkFactory.class, uowf);
        }
        if ((rer = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RuntimeEndpointRegistry.class)) != null) {
            camelContext.setRuntimeEndpointRegistry(rer);
        }
        if ((esr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, EndpointServiceRegistry.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(EndpointServiceRegistry.class, esr);
        }
        if ((mjcf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ModelJAXBContextFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(ModelJAXBContextFactory.class, mjcf);
        }
        if ((cr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ClassResolver.class)) != null) {
            camelContext.setClassResolver(cr);
        }
        if ((ffr = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, FactoryFinderResolver.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(FactoryFinderResolver.class, ffr);
        }
        if ((rc = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, RouteController.class)) != null) {
            camelContext.setRouteController(rc);
        }
        if ((ug = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, UuidGenerator.class)) != null) {
            camelContext.setUuidGenerator(ug);
        }
        if ((esm = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExecutorServiceManager.class)) != null) {
            camelContext.setExecutorServiceManager(esm);
        }
        if ((tpf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ThreadPoolFactory.class)) != null) {
            camelContext.getExecutorServiceManager().setThreadPoolFactory(tpf);
        }
        if ((pf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ProcessorFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(ProcessorFactory.class, pf);
        }
        if ((debugger = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, Debugger.class)) != null) {
            camelContext.setDebugger(debugger);
        }
        if ((nif = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, NodeIdFactory.class)) != null) {
            camelContext.getCamelContextExtension().addContextPlugin(NodeIdFactory.class, nif);
        }
        if ((mhf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, MessageHistoryFactory.class)) != null) {
            camelContext.setMessageHistoryFactory(mhf);
        }
        if ((re = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ReactiveExecutor.class)) != null) {
            camelContext.getCamelContextExtension().setReactiveExecutor(re);
        }
        if ((ss = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ShutdownStrategy.class)) != null) {
            camelContext.setShutdownStrategy(ss);
        }
        if ((exf = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, ExchangeFactory.class)) != null) {
            camelContext.getCamelContextExtension().setExchangeFactory(exf);
        }
        if (!(tcs = registry.findByType(TypeConverters.class)).isEmpty()) {
            tcs.forEach(t -> camelContext.getTypeConverterRegistry().addTypeConverters(t));
        }
        if (!(ens = registry.findByType(EventNotifier.class)).isEmpty()) {
            ens.forEach(n -> camelContext.getManagementStrategy().addEventNotifier((EventNotifier)n));
        }
        if (!(ess = registry.findByType(EndpointStrategy.class)).isEmpty()) {
            ess.forEach(camelContext.getCamelContextExtension()::registerEndpointCallback);
        }
        if (!(csss = registry.findByType(CamelClusterService.class)).isEmpty()) {
            for (CamelClusterService css : csss) {
                camelContext.addService(css);
            }
        }
        if (!(rpfs = registry.findByType(RoutePolicyFactory.class)).isEmpty()) {
            rpfs.forEach(camelContext::addRoutePolicyFactory);
        }
        Predicate<EventNotifier> containsEventNotifier = managementStrategy.getEventNotifiers()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, EventNotifier.class, containsEventNotifier.negate(), managementStrategy::addEventNotifier);
        Predicate<InterceptStrategy> containsInterceptStrategy = camelContext.getCamelContextExtension().getInterceptStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, InterceptStrategy.class, containsInterceptStrategy.negate(), camelContext.getCamelContextExtension()::addInterceptStrategy);
        Predicate<LifecycleStrategy> containsLifecycleStrategy = camelContext.getLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, LifecycleStrategy.class, containsLifecycleStrategy.negate(), camelContext::addLifecycleStrategy);
        ModelCamelContext mcc = (ModelCamelContext)camelContext;
        Predicate<ModelLifecycleStrategy> containsModelLifecycleStrategy = mcc.getModelLifecycleStrategies()::contains;
        DefaultConfigurationConfigurer.registerPropertiesForBeanTypesWithCondition(registry, ModelLifecycleStrategy.class, containsModelLifecycleStrategy.negate(), mcc::addModelLifecycleStrategy);
        Map<String, LogListener> logListeners = registry.findByTypeWithName(LogListener.class);
        if (logListeners != null && !logListeners.isEmpty()) {
            for (LogListener logListener : logListeners.values()) {
                boolean bl = camelContext.getCamelContextExtension().getLogListeners() != null && camelContext.getCamelContextExtension().getLogListeners().contains(logListener);
                if (bl) continue;
                camelContext.getCamelContextExtension().addLogListener(logListener);
            }
        }
        if ((serviceRegistries = registry.findByTypeWithName(ServiceRegistry.class)) != null && !serviceRegistries.isEmpty()) {
            for (Map.Entry<String, ServiceRegistry> entry : serviceRegistries.entrySet()) {
                ServiceRegistry service = entry.getValue();
                if (service.getId() == null) {
                    service.setGeneratedId(camelContext.getUuidGenerator().generateUuid());
                }
                LOG.info("Adding Camel Cloud ServiceRegistry with id: {} and implementation: {}", (Object)service.getId(), (Object)service);
                camelContext.addService(service);
            }
        }
        if ((globalSSLContextParametersSupplier = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GlobalSSLContextParametersSupplier.class)) != null) {
            camelContext.setSSLContextParameters((SSLContextParameters)globalSSLContextParametersSupplier.get());
        }
        if ((healthCheckRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HealthCheckRegistry.class)) != null) {
            healthCheckRegistry.setCamelContext(camelContext);
            LOG.debug("Using HealthCheckRegistry: {}", (Object)healthCheckRegistry);
            camelContext.getCamelContextExtension().addContextPlugin(HealthCheckRegistry.class, healthCheckRegistry);
        } else {
            HealthCheckRegistry healthCheckRegistry2 = HealthCheckRegistry.get(camelContext);
            if (healthCheckRegistry2 != null) {
                healthCheckRegistry2.setCamelContext(camelContext);
            }
        }
        if (var44_51 != null && ObjectHelper.isNotEmpty(repositories = registry.findByType(HealthCheckRepository.class))) {
            for (HealthCheckRepository healthCheckRepository : repositories) {
                var44_51.register(healthCheckRepository);
            }
        }
        if ((devConsoleRegistry = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, DevConsoleRegistry.class)) != null) {
            devConsoleRegistry.setCamelContext(camelContext);
            LOG.debug("Using DevConsoleRegistry: {}", (Object)devConsoleRegistry);
            camelContext.getCamelContextExtension().addContextPlugin(DevConsoleRegistry.class, devConsoleRegistry);
        } else {
            devConsoleRegistry = DevConsoleRegistry.get(camelContext);
            if (devConsoleRegistry != null) {
                devConsoleRegistry.setCamelContext(camelContext);
            }
        }
        if (devConsoleRegistry != null) {
            Set<DevConsole> consoles = registry.findByType(DevConsole.class);
            for (DevConsole console : consoles) {
                devConsoleRegistry.register(console);
            }
        }
        DefaultConfigurationConfigurer.initThreadPoolProfiles(registry, camelContext);
        AwsVaultConfiguration aws = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AwsVaultConfiguration.class);
        if (aws != null) {
            VaultConfiguration vaultConfiguration = camelContext.getVaultConfiguration();
            vaultConfiguration.setAwsVaultConfiguration(aws);
        }
        if ((gcpVaultConfiguration = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, GcpVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setGcpVaultConfiguration(gcpVaultConfiguration);
        }
        if ((azure = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, AzureVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setAzureVaultConfiguration(azure);
        }
        if ((hashicorp = DefaultConfigurationConfigurer.getSingleBeanOfType(registry, HashicorpVaultConfiguration.class)) != null) {
            VaultConfiguration vault = camelContext.getVaultConfiguration();
            vault.setHashicorpVaultConfiguration(hashicorp);
        }
        DefaultConfigurationConfigurer.configureVault(camelContext);
        Set<CamelContextCustomizer> customizers = registry.findByType(CamelContextCustomizer.class);
        if (!customizers.isEmpty()) {
            customizers.stream().sorted(Comparator.comparing(CamelContextCustomizer::getOrder)).forEach(c -> c.configure(camelContext));
        }
    }

    static void configureVault(CamelContext camelContext) throws Exception {
        PeriodTaskScheduler scheduler;
        DefaultContextReloadStrategy reloader;
        Runnable r;
        long period;
        Optional<Runnable> task;
        VaultConfiguration vc = camelContext.getVaultConfiguration();
        if (vc == null) {
            return;
        }
        if (vc.aws().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver(camelContext).newInstance("aws-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.aws().getRefreshPeriod();
            r = task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration(period, false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService(reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler(camelContext);
            scheduler.schedulePeriodTask(r, period);
        }
        if (vc.gcp().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver(camelContext).newInstance("gcp-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.gcp().getRefreshPeriod();
            r = task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration(period, false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService(reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler(camelContext);
            scheduler.schedulePeriodTask(r, period);
        }
        if (vc.azure().isRefreshEnabled() && (task = PluginHelper.getPeriodTaskResolver(camelContext).newInstance("azure-secret-refresh", Runnable.class)).isPresent()) {
            period = vc.azure().getRefreshPeriod();
            r = task.get();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling: {} (period: {})", (Object)r, (Object)TimeUtils.printDuration(period, false));
            }
            if (camelContext.hasService(ContextReloadStrategy.class) == null) {
                reloader = new DefaultContextReloadStrategy();
                camelContext.addService(reloader);
            }
            scheduler = PluginHelper.getPeriodTaskScheduler(camelContext);
            scheduler.schedulePeriodTask(r, period);
        }
    }

    public static void afterPropertiesSet(CamelContext camelContext) throws Exception {
    }

    private static <T> T getSingleBeanOfType(Registry registry, Class<T> type) {
        Map<String, T> beans = registry.findByTypeWithName(type);
        if (beans.size() == 1) {
            return beans.values().iterator().next();
        }
        return null;
    }

    private static <T> void registerPropertiesForBeanTypesWithCondition(Registry registry, Class<T> beanType, Predicate<T> condition, Consumer<T> propertySetter) {
        Map<String, T> beans = registry.findByTypeWithName(beanType);
        if (!ObjectHelper.isNotEmpty(beans)) {
            return;
        }
        String simpleName = beanType.getSimpleName();
        beans.forEach((name, bean) -> {
            if (condition.test(bean)) {
                LOG.info("Adding custom {} with id: {} and implementation: {}", new Object[]{simpleName, name, bean});
                propertySetter.accept(bean);
            }
        });
    }

    private static void initThreadPoolProfiles(Registry registry, CamelContext camelContext) {
        HashSet<String> defaultIds = new HashSet<String>();
        Map<String, ThreadPoolProfile> profiles = registry.findByTypeWithName(ThreadPoolProfile.class);
        if (profiles != null && !profiles.isEmpty()) {
            for (Map.Entry<String, ThreadPoolProfile> entry : profiles.entrySet()) {
                ThreadPoolProfile profile = entry.getValue();
                if (profile.isDefaultProfile().booleanValue()) {
                    LOG.info("Using custom default ThreadPoolProfile with id: {} and implementation: {}", (Object)entry.getKey(), (Object)profile);
                    camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(profile);
                    defaultIds.add(entry.getKey());
                    continue;
                }
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(profile);
            }
        }
        if (defaultIds.size() > 1) {
            throw new IllegalArgumentException("Only exactly one default ThreadPoolProfile is allowed, was " + defaultIds.size() + " ids: " + String.valueOf(defaultIds));
        }
    }
}

