/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Comparator;
import org.apache.camel.Expression;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="sort")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SortDefinition<T>
extends ExpressionNode {
    @XmlTransient
    private Comparator<? super T> comparatorBean;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.Comparator")
    private String comparator;

    public SortDefinition() {
    }

    protected SortDefinition(SortDefinition source) {
        super(source);
        this.comparatorBean = source.comparatorBean;
        this.comparator = source.comparator;
    }

    public SortDefinition(Expression expression) {
        this.setExpression(ExpressionNodeHelper.toExpressionDefinition(expression));
    }

    public SortDefinition(Expression expression, Comparator<? super T> comparator) {
        this(expression);
        this.comparatorBean = comparator;
    }

    @Override
    public SortDefinition copyDefinition() {
        return new SortDefinition<T>(this);
    }

    public String toString() {
        return "sort[" + String.valueOf(this.getExpression()) + " by: " + String.valueOf(this.comparator != null ? "ref:" + this.comparator : this.comparatorBean) + "]";
    }

    @Override
    public String getShortName() {
        return "sort";
    }

    @Override
    public String getLabel() {
        return "sort[" + String.valueOf(this.getExpression()) + "]";
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public SortDefinition<T> comparator(Comparator<T> comparator) {
        this.comparatorBean = comparator;
        return this;
    }

    public SortDefinition<T> comparator(String ref) {
        this.setComparator(ref);
        return this;
    }

    public Comparator<? super T> getComparatorBean() {
        return this.comparatorBean;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }
}

