/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.rest;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.rest.RestContainer;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceAware;

@Metadata(label="rest")
@XmlRootElement(name="rests")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestsDefinition
extends OptionalIdentifiedDefinition<RestsDefinition>
implements RestContainer,
ResourceAware {
    @XmlElementRef
    private List<RestDefinition> rests = new ArrayList<RestDefinition>();
    @XmlTransient
    private Resource resource;

    public String toString() {
        return "Rests: " + String.valueOf(this.rests);
    }

    @Override
    public String getShortName() {
        return "rests";
    }

    @Override
    public String getLabel() {
        return "Rest " + this.getId();
    }

    @Override
    public List<RestDefinition> getRests() {
        return this.rests;
    }

    @Override
    public void setRests(List<RestDefinition> rests) {
        this.rests = rests;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public RestDefinition rest() {
        RestDefinition rest = this.createRest();
        return this.rest(rest);
    }

    public RestDefinition rest(String uri) {
        RestDefinition rest = this.createRest();
        rest.setPath(uri);
        return this.rest(rest);
    }

    public RestDefinition rest(RestDefinition rest) {
        this.getRests().add(rest);
        return rest;
    }

    protected RestDefinition createRest() {
        RestDefinition rest = new RestDefinition();
        if (this.resource != null) {
            rest.setResource(this.resource);
        }
        return rest;
    }
}

