/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;

public class SetVariablesProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final List<Expression> variableNames;
    private final List<Expression> expressions;

    public SetVariablesProcessor(List<Expression> variableNames, List<Expression> expressions) {
        this.variableNames = variableNames;
        this.expressions = expressions;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            int variableIndex = 0;
            for (Expression expression : this.expressions) {
                Object newVariable = expression.evaluate(exchange, Object.class);
                if (exchange.getException() != null) {
                    callback.done(true);
                    return true;
                }
                String key = this.variableNames.get(variableIndex++).evaluate(exchange, String.class);
                ExchangeHelper.setVariable(exchange, key, newVariable);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        StringBuilder sb = new StringBuilder("setVariables[");
        int variableIndex = 0;
        for (Expression expression : this.expressions) {
            if (variableIndex > 0) {
                sb.append("; ");
            }
            sb.append(this.variableNames.get(variableIndex++).toString());
            sb.append(", ");
            sb.append(expression.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public List<Expression> getVariableNames() {
        return this.variableNames;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }
}

