/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.lang.reflect.Constructor;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;

public class ThrowExceptionProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware,
CamelContextAware {
    private String id;
    private String routeId;
    private CamelContext camelContext;
    private Expression simple;
    private final Exception exception;
    private final Class<? extends Exception> type;
    private final String message;

    public ThrowExceptionProcessor(Exception exception) {
        this(exception, null, null);
    }

    public ThrowExceptionProcessor(Exception exception, Class<? extends Exception> type, String message) {
        this.exception = exception;
        this.type = type;
        this.message = message;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exception cause = this.exception;
        try {
            if (this.message != null && this.type != null) {
                String text = this.simple.evaluate(exchange, String.class);
                Constructor<? extends Exception> constructor = this.type.getConstructor(String.class);
                cause = constructor.newInstance(text);
                exchange.setException(cause);
            } else if (cause == null && this.type != null) {
                Constructor<? extends Exception> constructor = this.type.getDeclaredConstructor(new Class[0]);
                cause = constructor.newInstance(new Object[0]);
                exchange.setException(cause);
            } else {
                exchange.setException(cause);
            }
        }
        catch (Exception e) {
            Class<Exception> exceptionClass = this.exception != null ? this.exception.getClass() : this.type;
            exchange.setException(new CamelExchangeException("Error creating new instance of " + String.valueOf(exceptionClass), exchange, e));
        }
        callback.done(true);
        return true;
    }

    @Override
    public String getTraceLabel() {
        String className = this.exception == null ? this.type.getSimpleName() : this.exception.getClass().getSimpleName();
        return "throwException[" + className + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Exception getException() {
        return this.exception;
    }

    public Class<? extends Exception> getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String toString() {
        return this.id;
    }

    @Override
    protected void doInit() throws Exception {
        ObjectHelper.notNull(this.camelContext, "camelContext", this);
        if (this.message != null) {
            this.simple = this.camelContext.resolveLanguage("simple").createExpression(this.message);
        }
    }
}

