/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.ArrayList;
import org.apache.camel.Exchange;
import org.apache.camel.ExpressionFactory;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.ChoiceProcessor;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.ExpressionFactoryAware;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceReifier
extends ProcessorReifier<ChoiceDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(ChoiceReifier.class);

    public ChoiceReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ChoiceDefinition)ChoiceDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean isPrecondition = Boolean.TRUE == this.parseBoolean(((ChoiceDefinition)this.definition).getPrecondition());
        ArrayList<FilterProcessor> filters = isPrecondition ? null : new ArrayList<FilterProcessor>();
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            this.initBranch(whenClause);
            if (filters == null) continue;
            filters.add((FilterProcessor)this.createProcessor(whenClause));
        }
        if (isPrecondition) {
            return this.getMatchingBranchProcessor();
        }
        Processor otherwiseProcessor = null;
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            otherwiseProcessor = this.createProcessor(((ChoiceDefinition)this.definition).getOtherwise());
        }
        return new ChoiceProcessor(filters, otherwiseProcessor);
    }

    private void initBranch(WhenDefinition whenClause) {
        ExpressionFactory model;
        ExpressionFactoryAware aware;
        Predicate pre;
        ExpressionDefinition exp = whenClause.getExpression();
        if (exp.getExpressionType() != null) {
            exp = exp.getExpressionType();
        }
        if ((pre = exp.getPredicate()) instanceof ExpressionFactoryAware && (aware = (ExpressionFactoryAware)((Object)pre)).getExpressionFactory() != null && (model = aware.getExpressionFactory()) instanceof ExpressionDefinition) {
            whenClause.setExpression((ExpressionDefinition)model);
        }
    }

    private Processor getMatchingBranchProcessor() throws Exception {
        Exchange dummy = ExchangeHelper.getDummy(this.camelContext);
        for (WhenDefinition whenClause : ((ChoiceDefinition)this.definition).getWhenClauses()) {
            ExpressionDefinition exp = whenClause.getExpression();
            exp.initPredicate(this.camelContext);
            Predicate predicate = exp.getPredicate();
            predicate.initPredicate(this.camelContext);
            boolean matches = predicate.matches(dummy);
            if (!matches) continue;
            LOG.debug("doSwitch selected: {}", (Object)whenClause.getLabel());
            return this.createOutputsProcessor(whenClause.getOutputs());
        }
        if (((ChoiceDefinition)this.definition).getOtherwise() != null) {
            LOG.debug("doSwitch selected: otherwise");
            return this.createProcessor(((ChoiceDefinition)this.definition).getOtherwise());
        }
        LOG.debug("doSwitch no when or otherwise selected");
        return null;
    }
}

