/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.Optional;
import org.apache.camel.CamelContextAware;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ResumableDefinition;
import org.apache.camel.processor.resume.ResumableProcessor;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.resume.ResumeStrategyConfiguration;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.util.ObjectHelper;

public class ResumableReifier
extends ProcessorReifier<ResumableDefinition> {
    protected ResumableReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (ResumableDefinition)ResumableDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor childProcessor = this.createChildProcessor(false);
        ResumeStrategy resumeStrategy = this.resolveResumeStrategy();
        ObjectHelper.notNull(resumeStrategy, "resumeStrategy", this.definition);
        if (resumeStrategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)resumeStrategy)).setCamelContext(this.camelContext);
        }
        this.route.setResumeStrategy(resumeStrategy);
        LoggingLevel loggingLevel = this.resolveLoggingLevel();
        boolean intermittent = this.parseBoolean(((ResumableDefinition)this.definition).getIntermittent(), false);
        return new ResumableProcessor(resumeStrategy, childProcessor, loggingLevel, intermittent);
    }

    protected ResumeStrategy resolveResumeStrategy() {
        ResumeStrategy strategy = ((ResumableDefinition)this.definition).getResumeStrategyBean();
        if (strategy == null) {
            String ref = this.parseString(((ResumableDefinition)this.definition).getResumeStrategy());
            if (ref != null) {
                strategy = this.mandatoryLookup(ref, ResumeStrategy.class);
            } else {
                ResumeStrategyConfiguration resumeStrategyConfiguration;
                FactoryFinder factoryFinder = this.camelContext.getCamelContextExtension().getFactoryFinder("META-INF/services/org/apache/camel/");
                Optional<ResumeStrategy> resumeStrategyOptional = factoryFinder.newInstance((resumeStrategyConfiguration = ((ResumableDefinition)this.definition).getResumeStrategyConfiguration()).resumeStrategyService(), ResumeStrategy.class);
                if (resumeStrategyOptional.isEmpty()) {
                    throw new RuntimeCamelException("Cannot find a resume strategy class in the classpath or the registry");
                }
                ResumeStrategy resumeStrategy = resumeStrategyOptional.get();
                resumeStrategy.setResumeStrategyConfiguration(resumeStrategyConfiguration);
                return resumeStrategy;
            }
        }
        return strategy;
    }

    protected LoggingLevel resolveLoggingLevel() {
        LoggingLevel loggingLevel = this.parse(LoggingLevel.class, ((ResumableDefinition)this.definition).getLoggingLevel());
        if (loggingLevel == null) {
            loggingLevel = LoggingLevel.ERROR;
        }
        return loggingLevel;
    }
}

